/*
 * Decompiled with CFR 0.152.
 */
package Vimptech.Vmenu;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GoogleSync {
    public static final String APPLICATION_NAME = "VmenuGoogleDriveApi";
    public static JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    public static String TOKENS_DIRECTORY_PATH = "token";
    public static List<String> SCOPES = Collections.singletonList("https://www.googleapis.com/auth/drive");
    public static String CREDENTIALS_FILE_PATH = "credentials.json";

    private Credential getCredentials(NetHttpTransport HTTP_TRANSPORT) throws IOException {
        InputStream in = GoogleSync.class.getResourceAsStream(CREDENTIALS_FILE_PATH);
        if (in == null) {
            System.out.println("Eroor");
            throw new FileNotFoundException("Resource not found: " + CREDENTIALS_FILE_PATH);
        }
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(in));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, SCOPES).setDataStoreFactory((DataStoreFactory)new FileDataStoreFactory(new File(TOKENS_DIRECTORY_PATH))).setAccessType("offline").build();
        LocalServerReceiver receiver = new LocalServerReceiver.Builder().setPort(8888).build();
        return new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)receiver).authorize("user");
    }

    public Drive IntializeGoogleService() throws GeneralSecurityException, IOException {
        NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
        Drive service = new Drive.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)this.getCredentials(HTTP_TRANSPORT)).setApplicationName(APPLICATION_NAME).build();
        return service;
    }

    public String CreateFolder(Drive service, String Foldername, String parentfolderid) throws IOException {
        com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
        fileMetadata.setName(Foldername);
        fileMetadata.setMimeType("application/vnd.google-apps.folder");
        if (parentfolderid != null) {
            fileMetadata.setParents(Collections.singletonList(parentfolderid));
        }
        com.google.api.services.drive.model.File file = (com.google.api.services.drive.model.File)service.files().create(fileMetadata).setFields("id").execute();
        return file.getId();
    }

    public ArrayList<ArrayList<String>> GetFileNamesAndIdFilesizeFromSpeficFolder(Drive service, String folderid) throws IOException {
        FileList result;
        String pageToken = null;
        String query = "'" + folderid + "' in parents and trashed=false ";
        ArrayList file_names = new ArrayList();
        ArrayList file_id = new ArrayList();
        ArrayList file_size = new ArrayList();
        do {
            result = (FileList)service.files().list().setQ(query).setSpaces("drive").setFields("nextPageToken, files(id,name,size)").setOrderBy("createdTime").setPageToken(pageToken).execute();
            result.getFiles().forEach(file -> {
                file_names.add(file.getName());
                file_id.add(file.getId());
                file_size.add(String.valueOf(file.getSize()));
            });
        } while ((pageToken = result.getNextPageToken()) != null);
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        data.add(file_names);
        data.add(file_id);
        data.add(file_size);
        return data;
    }

    public ArrayList<String> SearchMultipleSameNameFolders(Drive service, String foldername) {
        FileList result;
        String pageToken = null;
        ArrayList<String> folderid = new ArrayList<String>();
        do {
            result = null;
            try {
                result = (FileList)service.files().list().setQ("mimeType ='application/vnd.google-apps.folder' and trashed =false ").setSpaces("drive").setFields("nextPageToken, files(id,name)").setPageToken(pageToken).execute();
            }
            catch (IOException ex) {
                Logger.getLogger(GoogleSync.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (com.google.api.services.drive.model.File file : result.getFiles()) {
                if (!file.getName().contentEquals(foldername)) continue;
                folderid.add(file.getId());
            }
        } while ((pageToken = result.getNextPageToken()) != null);
        return folderid;
    }

    public String SearchFolder(Drive service, String foldername) {
        FileList result;
        String pageToken = null;
        String folderid = null;
        block2: do {
            result = null;
            try {
                result = (FileList)service.files().list().setQ("mimeType ='application/vnd.google-apps.folder' and trashed =false ").setSpaces("drive").setFields("nextPageToken, files(id,name)").setPageToken(pageToken).execute();
            }
            catch (IOException ex) {
                Logger.getLogger(GoogleSync.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (com.google.api.services.drive.model.File file : result.getFiles()) {
                if (!file.getName().contentEquals(foldername)) continue;
                folderid = file.getId();
                continue block2;
            }
        } while ((pageToken = result.getNextPageToken()) != null);
        return folderid;
    }

    public ArrayList<String> SearchFile(Drive service, String filename) {
        FileList result;
        String pageToken = null;
        ArrayList<String> data = new ArrayList<String>();
        block2: do {
            result = null;
            try {
                result = (FileList)service.files().list().setQ(" trashed =false ").setSpaces("drive").setFields("nextPageToken, files(id,name,size)").setPageToken(pageToken).execute();
            }
            catch (IOException ex) {
                Logger.getLogger(GoogleSync.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (com.google.api.services.drive.model.File file : result.getFiles()) {
                if (!file.getName().contentEquals(filename)) continue;
                data.add(file.getName());
                data.add(file.getId());
                data.add(String.valueOf(file.getSize()));
                continue block2;
            }
        } while ((pageToken = result.getNextPageToken()) != null);
        return data;
    }

    public ArrayList<ArrayList<String>> GetAllFolderAndFiles(Drive service) throws IOException {
        FileList result;
        String pageToken = null;
        ArrayList file_names = new ArrayList();
        ArrayList file_id = new ArrayList();
        ArrayList file_size = new ArrayList();
        do {
            result = (FileList)service.files().list().setSpaces("drive").setQ("trashed = false").setFields("nextPageToken, files(id,name,size)").setPageToken(pageToken).execute();
            result.getFiles().stream().map(file -> {
                file_names.add(file.getName());
                return file;
            }).map(file -> {
                file_id.add(file.getId());
                return file;
            }).forEachOrdered(file -> file_size.add(String.valueOf(file.getSize())));
        } while ((pageToken = result.getNextPageToken()) != null);
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        data.add(file_names);
        data.add(file_id);
        data.add(file_size);
        return data;
    }

    public HttpResponse DownloadFileFromDrive(Drive service, String DownloadFileName, String DownloadFileId) throws IOException {
        HttpResponse httpResponse = null;
        String ex = DownloadFileName.substring(DownloadFileName.lastIndexOf(".") + 1);
        try {
            Drive.Files f = service.files();
            if (ex.equalsIgnoreCase("xlsx")) {
                httpResponse = f.export(DownloadFileId, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet").executeMedia();
            } else if (ex.equalsIgnoreCase("docx")) {
                httpResponse = f.export(DownloadFileId, "application/vnd.openxmlformats-officedocument.wordprocessingml.document").executeMedia();
            } else if (ex.equalsIgnoreCase("pptx")) {
                httpResponse = f.export(DownloadFileId, "application/vnd.openxmlformats-officedocument.presentationml.presentation").executeMedia();
            } else if (ex.equalsIgnoreCase("pdf") || ex.equalsIgnoreCase("txt") || ex.equalsIgnoreCase("png") || ex.equalsIgnoreCase("zip")) {
                Drive.Files.Get get = f.get(DownloadFileId);
                httpResponse = get.executeMedia();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return httpResponse;
    }

    public ArrayList<Object> UploadFileTogoogleDrive(Drive service, String CloudfileNameWithExtention, String uploadfileLocalDirectory, String uploadFolderid) throws IOException {
        com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
        fileMetadata.setName(CloudfileNameWithExtention);
        if (uploadFolderid != null) {
            fileMetadata.setParents(Collections.singletonList(uploadFolderid));
        }
        File f1 = new File(uploadfileLocalDirectory);
        FileContent mediaContent = new FileContent("application/unknown", f1);
        Drive.Files.Create insert = service.files().create(fileMetadata, (AbstractInputStreamContent)mediaContent);
        MediaHttpUploader uploader = insert.getMediaHttpUploader();
        uploader.setChunkSize(262144);
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(uploader);
        data.add(insert);
        return data;
    }

    public void MoveFileToTrash(Drive service, String Fileid) {
        com.google.api.services.drive.model.File newContent = new com.google.api.services.drive.model.File();
        newContent.setTrashed(Boolean.valueOf(true));
        try {
            service.files().update(Fileid, newContent).execute();
        }
        catch (IOException ex) {
            Logger.getLogger(GoogleSync.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void DeleteFile(Drive service, String fileId) {
        try {
            service.files().delete(fileId).execute();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

