/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;

public class ImageRenderer
extends AbstractRenderer {
    private float height;
    private Float width;
    protected Float fixedXPosition;
    protected Float fixedYPosition;
    protected float pivotY;
    protected float deltaX;
    protected float imageWidth;
    protected float imageHeight;
    float[] matrix = new float[6];

    public ImageRenderer(Image image) {
        super(image);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        LayoutArea area = layoutContext.getArea().clone();
        Rectangle layoutBox = area.getBBox();
        this.applyMargins(layoutBox, false);
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), 0.0f, 0.0f));
        this.width = this.retrieveWidth(layoutBox.getWidth());
        Float angle = this.getPropertyAsFloat(55);
        PdfXObject xObject = ((Image)this.getModelElement()).getXObject();
        this.imageWidth = xObject.getWidth();
        this.imageHeight = xObject.getHeight();
        this.width = Float.valueOf(this.width == null ? this.imageWidth : this.width.floatValue());
        this.height = this.width.floatValue() / this.imageWidth * this.imageHeight;
        this.fixedXPosition = this.getPropertyAsFloat(79);
        this.fixedYPosition = this.getPropertyAsFloat(80);
        Float horizontalScaling = this.getPropertyAsFloat(29);
        Float verticalScaling = this.getPropertyAsFloat(76);
        AffineTransform t = new AffineTransform();
        if (xObject instanceof PdfFormXObject && this.width.floatValue() != this.imageWidth) {
            horizontalScaling = Float.valueOf(horizontalScaling.floatValue() * (this.width.floatValue() / this.imageWidth));
            verticalScaling = Float.valueOf(verticalScaling.floatValue() * (this.height / this.imageHeight));
        }
        if (horizontalScaling.floatValue() != 1.0f) {
            if (xObject instanceof PdfFormXObject) {
                t.scale((double)horizontalScaling.floatValue(), 1.0);
            }
            this.width = Float.valueOf(this.width.floatValue() * horizontalScaling.floatValue());
        }
        if (verticalScaling.floatValue() != 1.0f) {
            if (xObject instanceof PdfFormXObject) {
                t.scale(1.0, (double)verticalScaling.floatValue());
            }
            this.height *= verticalScaling.floatValue();
        }
        float imageItselfScaledWidth = this.width.floatValue();
        float imageItselfScaledHeight = this.height;
        if (null == angle) {
            angle = Float.valueOf(0.0f);
        }
        t.rotate((double)angle.floatValue());
        float scaleCoef = this.adjustPositionAfterRotation(angle.floatValue(), layoutBox.getWidth(), layoutBox.getHeight());
        imageItselfScaledHeight *= scaleCoef;
        imageItselfScaledWidth *= scaleCoef;
        if (xObject instanceof PdfFormXObject) {
            t.scale((double)scaleCoef, (double)scaleCoef);
        }
        this.getMatrix(t, imageItselfScaledWidth, imageItselfScaledHeight);
        if (!this.getPropertyAsBoolean(26).booleanValue() && (this.width.floatValue() > layoutBox.getWidth() || this.height > layoutBox.getHeight())) {
            return new LayoutResult(3, this.occupiedArea, null, this);
        }
        this.occupiedArea.getBBox().moveDown(this.height);
        this.occupiedArea.getBBox().setHeight(this.height);
        this.occupiedArea.getBBox().setWidth(this.width.floatValue());
        float leftMargin = this.getPropertyAsFloat(44).floatValue();
        float topMargin = this.getPropertyAsFloat(46).floatValue();
        if (leftMargin != 0.0f || topMargin != 0.0f) {
            this.translateImage(leftMargin, topMargin, t);
            this.getMatrix(t, imageItselfScaledWidth, imageItselfScaledHeight);
        }
        this.applyMargins(this.occupiedArea.getBBox(), true);
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        super.draw(drawContext);
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        boolean isArtifact = false;
        TagTreePointer tagPointer = null;
        if (isTagged) {
            tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
            IAccessibleElement accessibleElement = (IAccessibleElement)this.getModelElement();
            PdfName role = accessibleElement.getRole();
            if (role != null && !PdfName.Artifact.equals((Object)role)) {
                AccessibleAttributesApplier.applyLayoutAttributes(accessibleElement.getRole(), this, document);
                tagPointer.addTag(accessibleElement);
            } else {
                isTagged = false;
                if (PdfName.Artifact.equals((Object)role)) {
                    isArtifact = true;
                }
            }
        }
        this.applyMargins(this.occupiedArea.getBBox(), false);
        int position = this.getPropertyAsInteger(52);
        if (position == 2) {
            this.applyAbsolutePositioningTranslation(false);
        }
        if (this.fixedYPosition == null) {
            this.fixedYPosition = Float.valueOf(this.occupiedArea.getBBox().getY() + this.pivotY);
        }
        if (this.fixedXPosition == null) {
            this.fixedXPosition = Float.valueOf(this.occupiedArea.getBBox().getX());
        }
        PdfCanvas canvas = drawContext.getCanvas();
        if (isTagged) {
            canvas.openTag(tagPointer.getTagReference());
        } else if (isArtifact) {
            canvas.openTag((CanvasTag)new CanvasArtifact());
        }
        PdfXObject xObject = ((Image)this.getModelElement()).getXObject();
        canvas.addXObject(xObject, this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[3], this.fixedXPosition.floatValue() + this.deltaX, this.fixedYPosition.floatValue());
        if (Boolean.valueOf(true).equals(this.getPropertyAsBoolean(19))) {
            xObject.flush();
        }
        if (isTagged || isArtifact) {
            canvas.closeTag();
        }
        if (position == 2) {
            this.applyAbsolutePositioningTranslation(true);
        }
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (isTagged) {
            tagPointer.moveToParent();
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return null;
    }

    protected ImageRenderer autoScale(LayoutArea area) {
        if (this.width.floatValue() > area.getBBox().getWidth()) {
            this.setProperty(27, Float.valueOf(area.getBBox().getWidth() / this.width.floatValue() * this.imageHeight));
            this.setProperty(77, UnitValue.createPointValue(area.getBBox().getWidth()));
            if (this.getPropertyAsFloat(27).floatValue() > area.getBBox().getHeight()) {
                this.setProperty(77, UnitValue.createPointValue(area.getBBox().getHeight() / this.getPropertyAsFloat(27).floatValue() * ((UnitValue)this.getProperty(77)).getValue()));
                this.setProperty(27, UnitValue.createPointValue(area.getBBox().getHeight()));
            }
        }
        return this;
    }

    private void getMatrix(AffineTransform t, float imageItselfScaledWidth, float imageItselfScaledHeight) {
        t.getMatrix(this.matrix);
        PdfXObject xObject = ((Image)this.getModelElement()).getXObject();
        if (xObject instanceof PdfImageXObject) {
            this.matrix[0] = this.matrix[0] * imageItselfScaledWidth;
            this.matrix[1] = this.matrix[1] * imageItselfScaledWidth;
            this.matrix[2] = this.matrix[2] * imageItselfScaledHeight;
            this.matrix[3] = this.matrix[3] * imageItselfScaledHeight;
        }
    }

    private float adjustPositionAfterRotation(float angle, float maxWidth, float maxHeight) {
        if (angle != 0.0f) {
            AffineTransform t = AffineTransform.getRotateInstance((double)angle);
            Point p00 = t.transform(new Point(0, 0), new Point());
            Point p01 = t.transform(new Point(0.0, (double)this.height), new Point());
            Point p10 = t.transform(new Point((double)this.width.floatValue(), 0.0), new Point());
            Point p11 = t.transform(new Point((double)this.width.floatValue(), (double)this.height), new Point());
            double[] xValues = new double[]{p01.getX(), p10.getX(), p11.getX()};
            double[] yValues = new double[]{p01.getY(), p10.getY(), p11.getY()};
            double minX = p00.getX();
            double minY = p00.getY();
            double maxX = minX;
            double maxY = minY;
            for (double x : xValues) {
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
            }
            for (double y : yValues) {
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
            }
            this.height = (float)(maxY - minY);
            this.width = Float.valueOf((float)(maxX - minX));
            this.pivotY = (float)(p00.getY() - minY);
            this.deltaX = -((float)minX);
        }
        float scaleCoeff = 1.0f;
        if (null != this.getPropertyAsBoolean(3) && this.getPropertyAsBoolean(3).booleanValue()) {
            scaleCoeff = Math.min(maxWidth / this.width.floatValue(), maxHeight / this.height);
            this.height *= scaleCoeff;
            this.width = Float.valueOf(this.width.floatValue() * scaleCoeff);
        } else if (null != this.getPropertyAsBoolean(5) && this.getPropertyAsBoolean(5).booleanValue()) {
            scaleCoeff = maxWidth / this.width.floatValue();
            this.height *= scaleCoeff;
            this.width = Float.valueOf(maxWidth);
        } else if (null != this.getPropertyAsBoolean(4) && this.getPropertyAsBoolean(4).booleanValue()) {
            scaleCoeff = maxHeight / this.height;
            this.height = maxHeight;
            this.width = Float.valueOf(this.width.floatValue() * scaleCoeff);
        }
        this.pivotY *= scaleCoeff;
        return scaleCoeff;
    }

    private void translateImage(float xDistance, float yDistance, AffineTransform t) {
        t.translate((double)xDistance, (double)yDistance);
        t.getMatrix(this.matrix);
        if (this.fixedXPosition != null) {
            this.fixedXPosition = Float.valueOf(this.fixedXPosition.floatValue() + (float)t.getTranslateX());
        }
        if (this.fixedYPosition != null) {
            this.fixedYPosition = Float.valueOf(this.fixedYPosition.floatValue() + (float)t.getTranslateY());
        }
    }
}

