/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.xobject;

import com.itextpdf.io.IOException;
import com.itextpdf.io.codec.PngWriter;
import com.itextpdf.io.codec.TiffWriter;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.RawImageData;
import com.itextpdf.io.image.RawImageHelper;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.itextpdf.kernel.pdf.filters.DoNothingFilter;
import com.itextpdf.kernel.pdf.filters.FilterHandlers;
import com.itextpdf.kernel.pdf.filters.IFilterHandler;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class PdfImageXObject
extends PdfXObject {
    private static final long serialVersionUID = -205889576153966580L;
    private float width;
    private float height;
    private boolean mask;
    private boolean softMask;
    private int pngColorType = -1;
    private int pngBitDepth;
    private int bpc;
    private byte[] palette;
    private byte[] icc;
    private int stride;

    public PdfImageXObject(ImageData image) {
        this(image, null);
    }

    public PdfImageXObject(ImageData image, PdfImageXObject imageMask) {
        this(PdfImageXObject.createPdfStream(PdfImageXObject.checkImageType(image), imageMask));
        this.mask = image.isMask();
        this.softMask = image.isSoftMask();
    }

    public PdfImageXObject(PdfStream pdfObject) {
        super(pdfObject);
    }

    @Override
    public float getWidth() {
        if (!this.isFlushed()) {
            return ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Width).floatValue();
        }
        return this.width;
    }

    @Override
    public float getHeight() {
        if (!this.isFlushed()) {
            return ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Height).floatValue();
        }
        return this.height;
    }

    @Override
    public void flush() {
        if (!this.isFlushed()) {
            this.width = ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Width).floatValue();
            this.height = ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Height).floatValue();
            super.flush();
        }
    }

    public PdfImageXObject copyTo(PdfDocument document) {
        PdfImageXObject image = new PdfImageXObject(((PdfStream)this.getPdfObject()).copyTo(document));
        image.width = this.width;
        image.height = this.height;
        image.mask = this.mask;
        image.softMask = this.softMask;
        return image;
    }

    public BufferedImage getBufferedImage() throws java.io.IOException {
        byte[] img = this.getImageBytes();
        return ImageIO.read(new ByteArrayInputStream(img));
    }

    public byte[] getImageBytes() {
        return this.getImageBytes(true);
    }

    public byte[] getImageBytes(boolean decoded) {
        byte[] bytes = ((PdfStream)this.getPdfObject()).getBytes(false);
        if (decoded) {
            HashMap<PdfName, IFilterHandler> filters = new HashMap<PdfName, IFilterHandler>(FilterHandlers.getDefaultFilterHandlers());
            DoNothingFilter stubFilter = new DoNothingFilter();
            filters.put(PdfName.DCTDecode, stubFilter);
            filters.put(PdfName.JBIG2Decode, stubFilter);
            filters.put(PdfName.JPXDecode, stubFilter);
            bytes = PdfReader.decodeBytes(bytes, (PdfDictionary)this.getPdfObject(), filters);
            if (stubFilter.getLastFilterName() == null) {
                try {
                    bytes = this.decodeTiffAndPngBytes(bytes);
                }
                catch (java.io.IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return bytes;
    }

    public PdfImageXObject put(PdfName key, PdfObject value) {
        ((PdfStream)this.getPdfObject()).put(key, value);
        return this;
    }

    protected static PdfStream createPdfStream(ImageData image, PdfImageXObject imageMask) {
        int[] transparency;
        ImageData mask;
        PdfDictionary additional;
        PdfName colorSpace;
        if (image.getOriginalType() == ImageType.RAW) {
            RawImageHelper.updateImageAttributes((RawImageData)((RawImageData)image), null);
        }
        PdfStream stream = new PdfStream(image.getData());
        String filter = image.getFilter();
        if (filter != null && filter.equals("JPXDecode") && image.getColorSpace() <= 0) {
            stream.setCompressionLevel(0);
            image.setBpc(0);
        }
        stream.put(PdfName.Type, PdfName.XObject);
        stream.put(PdfName.Subtype, PdfName.Image);
        PdfDictionary decodeParms = PdfImageXObject.createDictionaryFromMap(stream, image.getDecodeParms());
        if (decodeParms != null) {
            stream.put(PdfName.DecodeParms, decodeParms);
        }
        switch (image.getColorSpace()) {
            case 1: {
                colorSpace = PdfName.DeviceGray;
                break;
            }
            case 3: {
                colorSpace = PdfName.DeviceRGB;
                break;
            }
            default: {
                colorSpace = PdfName.DeviceCMYK;
            }
        }
        stream.put(PdfName.ColorSpace, colorSpace);
        if (image.getBpc() != 0) {
            stream.put(PdfName.BitsPerComponent, new PdfNumber(image.getBpc()));
        }
        if (image.getFilter() != null) {
            stream.put(PdfName.Filter, new PdfName(image.getFilter()));
        }
        if (image.getColorSpace() == -1) {
            stream.remove(PdfName.ColorSpace);
        }
        if ((additional = PdfImageXObject.createDictionaryFromMap(stream, image.getImageAttributes())) != null) {
            stream.putAll(additional);
        }
        if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 255)) {
            stream.put(PdfName.ImageMask, PdfBoolean.TRUE);
        }
        if (imageMask != null) {
            if (imageMask.softMask) {
                stream.put(PdfName.SMask, (PdfObject)imageMask.getPdfObject());
            } else if (imageMask.mask) {
                stream.put(PdfName.Mask, (PdfObject)imageMask.getPdfObject());
            }
        }
        if ((mask = image.getImageMask()) != null) {
            if (mask.isSoftMask()) {
                stream.put(PdfName.SMask, (PdfObject)new PdfImageXObject(image.getImageMask()).getPdfObject());
            } else if (mask.isMask()) {
                stream.put(PdfName.Mask, (PdfObject)new PdfImageXObject(image.getImageMask()).getPdfObject());
            }
        }
        if (image.getDecode() != null) {
            stream.put(PdfName.Decode, new PdfArray(image.getDecode()));
        }
        if (image.isMask() && image.isInverted()) {
            stream.put(PdfName.Decode, new PdfArray(new float[]{1.0f, 0.0f}));
        }
        if (image.isInterpolation()) {
            stream.put(PdfName.Interpolate, PdfBoolean.TRUE);
        }
        if ((transparency = image.getTransparency()) != null && !image.isMask() && imageMask == null) {
            PdfArray t = new PdfArray();
            for (int transparencyItem : transparency) {
                t.add(new PdfNumber(transparencyItem));
            }
            stream.put(PdfName.Mask, t);
        }
        stream.put(PdfName.Width, new PdfNumber(image.getWidth()));
        stream.put(PdfName.Height, new PdfNumber(image.getHeight()));
        return stream;
    }

    private static PdfDictionary createDictionaryFromMap(PdfStream stream, Map<String, Object> parms) {
        if (parms != null) {
            PdfDictionary dictionary = new PdfDictionary();
            for (Map.Entry<String, Object> entry : parms.entrySet()) {
                Object value = entry.getValue();
                String key = entry.getKey();
                if (value instanceof Integer) {
                    dictionary.put(new PdfName(key), new PdfNumber((Integer)value));
                    continue;
                }
                if (value instanceof Float) {
                    dictionary.put(new PdfName(key), new PdfNumber(((Float)value).floatValue()));
                    continue;
                }
                if (value instanceof String) {
                    if (value.equals("Mask")) {
                        dictionary.put(PdfName.Mask, new PdfLiteral((String)value));
                        continue;
                    }
                    String str = (String)value;
                    if (str.indexOf(47) == 0) {
                        dictionary.put(new PdfName(key), new PdfName(str.substring(1)));
                        continue;
                    }
                    dictionary.put(new PdfName(key), new PdfString(str));
                    continue;
                }
                if (value instanceof byte[]) {
                    PdfStream globalsStream = new PdfStream();
                    globalsStream.getOutputStream().writeBytes((byte[])value);
                    dictionary.put(PdfName.JBIG2Globals, globalsStream);
                    continue;
                }
                if (value instanceof Boolean) {
                    dictionary.put(new PdfName(key), new PdfBoolean((Boolean)value));
                    continue;
                }
                if (value instanceof Object[]) {
                    dictionary.put(new PdfName(key), PdfImageXObject.createArray(stream, (Object[])value));
                    continue;
                }
                if (!(value instanceof float[])) continue;
                dictionary.put(new PdfName(key), new PdfArray((float[])value));
            }
            return dictionary;
        }
        return null;
    }

    private static PdfArray createArray(PdfStream stream, Object[] objects) {
        PdfArray array = new PdfArray();
        for (Object object : objects) {
            if (object instanceof String) {
                String str = (String)object;
                if (str.indexOf(47) == 0) {
                    array.add(new PdfName(str.substring(1)));
                    continue;
                }
                array.add(new PdfString(str));
                continue;
            }
            if (object instanceof Integer) {
                array.add(new PdfNumber((Integer)object));
                continue;
            }
            if (object instanceof Float) {
                array.add(new PdfNumber(((Float)object).floatValue()));
                continue;
            }
            if (!(object instanceof Map)) continue;
            array.add(PdfImageXObject.createDictionaryFromMap(stream, (Map)object));
        }
        return array;
    }

    private byte[] decodeTiffAndPngBytes(byte[] imageBytes) throws java.io.IOException {
        this.pngColorType = -1;
        PdfArray decode = ((PdfStream)this.getPdfObject()).getAsArray(PdfName.Decode);
        this.width = ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Width).intValue();
        this.height = ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Height).intValue();
        this.pngBitDepth = this.bpc = ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.BitsPerComponent).intValue();
        PdfObject colorspace = ((PdfStream)this.getPdfObject()).get(PdfName.ColorSpace);
        this.palette = null;
        this.icc = null;
        this.stride = 0;
        this.findColorspace(colorspace, true);
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        if (this.pngColorType < 0) {
            if (this.bpc != 8) {
                throw new IOException("the.color.depth {0} is.not.supported").setMessageParams(new Object[]{this.bpc});
            }
            if (colorspace instanceof PdfArray) {
                PdfArray ca = (PdfArray)colorspace;
                PdfObject tyca = ca.get(0);
                if (!PdfName.ICCBased.equals(tyca)) {
                    throw new IOException("the.color.space {0} is.not.supported").setMessageParams(new Object[]{tyca.toString()});
                }
                PdfStream pr = (PdfStream)ca.get(1);
                int n = pr.getAsNumber(PdfName.N).intValue();
                if (n != 4) {
                    throw new IOException("N.value.1.is.not.supported").setMessageParams(new Object[]{n});
                }
                this.icc = pr.getBytes();
            } else if (!PdfName.DeviceCMYK.equals(colorspace)) {
                throw new IOException("the.color.space {0} is.not.supported").setMessageParams(new Object[]{colorspace.toString()});
            }
            this.stride = (int)(4.0f * this.width);
            TiffWriter wr = new TiffWriter();
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(277, 4));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(258, new int[]{8, 8, 8, 8}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(262, 5));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(256, (int)this.width));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(257, (int)this.height));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(259, 5));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(317, 2));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(278, (int)this.height));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldRational(282, new int[]{300, 1}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldRational(283, new int[]{300, 1}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(296, 2));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldAscii(305, Version.getInstance().getVersion()));
            ByteArrayOutputStream comp = new ByteArrayOutputStream();
            TiffWriter.compressLZW((OutputStream)comp, (int)2, (byte[])imageBytes, (int)((int)this.height), (int)4, (int)this.stride);
            byte[] buf = comp.toByteArray();
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldImage(buf));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(279, buf.length));
            if (this.icc != null) {
                wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldUndefined(34675, this.icc));
            }
            wr.writeFile((OutputStream)ms);
            imageBytes = ms.toByteArray();
            return imageBytes;
        }
        PngWriter png = new PngWriter((OutputStream)ms);
        if (decode != null && this.pngBitDepth == 1 && decode.getAsNumber(0).intValue() == 1 && decode.getAsNumber(1).intValue() == 0) {
            int len = imageBytes.length;
            int t = 0;
            while (t < len) {
                int n = t++;
                imageBytes[n] = (byte)(imageBytes[n] ^ 0xFF);
            }
        }
        png.writeHeader((int)this.width, (int)this.height, this.pngBitDepth, this.pngColorType);
        if (this.icc != null) {
            png.writeIccProfile(this.icc);
        }
        if (this.palette != null) {
            png.writePalette(this.palette);
        }
        png.writeData(imageBytes, this.stride);
        png.writeEnd();
        imageBytes = ms.toByteArray();
        return imageBytes;
    }

    private void findColorspace(PdfObject colorspace, boolean allowIndexed) {
        if (colorspace == null && this.bpc == 1) {
            this.stride = (int)((this.width * (float)this.bpc + 7.0f) / 8.0f);
            this.pngColorType = 0;
        } else if (PdfName.DeviceGray.equals(colorspace)) {
            this.stride = (int)((this.width * (float)this.bpc + 7.0f) / 8.0f);
            this.pngColorType = 0;
        } else if (PdfName.DeviceRGB.equals(colorspace)) {
            if (this.bpc == 8 || this.bpc == 16) {
                this.stride = (int)((this.width * (float)this.bpc * 3.0f + 7.0f) / 8.0f);
                this.pngColorType = 2;
            }
        } else if (colorspace instanceof PdfArray) {
            PdfArray ca = (PdfArray)colorspace;
            PdfObject tyca = ca.get(0);
            if (PdfName.CalGray.equals(tyca)) {
                this.stride = (int)((this.width * (float)this.bpc + 7.0f) / 8.0f);
                this.pngColorType = 0;
            } else if (PdfName.CalRGB.equals(tyca)) {
                if (this.bpc == 8 || this.bpc == 16) {
                    this.stride = (int)((this.width * (float)this.bpc * 3.0f + 7.0f) / 8.0f);
                    this.pngColorType = 2;
                }
            } else if (PdfName.ICCBased.equals(tyca)) {
                PdfStream pr = (PdfStream)ca.get(1);
                int n = pr.getAsNumber(PdfName.N).intValue();
                if (n == 1) {
                    this.stride = (int)((this.width * (float)this.bpc + 7.0f) / 8.0f);
                    this.pngColorType = 0;
                    this.icc = pr.getBytes();
                } else if (n == 3) {
                    this.stride = (int)((this.width * (float)this.bpc * 3.0f + 7.0f) / 8.0f);
                    this.pngColorType = 2;
                    this.icc = pr.getBytes();
                }
            } else if (allowIndexed && PdfName.Indexed.equals(tyca)) {
                this.findColorspace(ca.get(1), false);
                if (this.pngColorType == 2) {
                    PdfObject id2 = ca.get(3);
                    if (id2 instanceof PdfString) {
                        this.palette = ((PdfString)id2).getValueBytes();
                    } else if (id2 instanceof PdfStream) {
                        this.palette = ((PdfStream)id2).getBytes();
                    }
                    this.stride = (int)((this.width * (float)this.bpc + 7.0f) / 8.0f);
                    this.pngColorType = 3;
                }
            }
        }
    }

    private static ImageData checkImageType(ImageData image) {
        if (image instanceof WmfImageData) {
            throw new PdfException("Cannot create PdfImageXObject instance by WmfImage. Use PdfFormXObject constructor instead.");
        }
        return image;
    }
}

