/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfNumTree;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagging.IPdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

class ParentTreeHandler
implements Serializable {
    private static final long serialVersionUID = 1593883864288316473L;
    private PdfStructTreeRoot structTreeRoot;
    private PdfNumTree parentTree;
    private Map<PdfIndirectReference, TreeMap<Integer, PdfMcr>> pageToPageMcrs;

    ParentTreeHandler(PdfStructTreeRoot structTreeRoot) {
        this.structTreeRoot = structTreeRoot;
        this.parentTree = new PdfNumTree(structTreeRoot.getDocument().getCatalog(), PdfName.ParentTree);
        this.registerAllMcrs();
    }

    public Map<Integer, PdfMcr> getPageMarkedContentReferences(PdfPage page) {
        return this.pageToPageMcrs.get(((PdfDictionary)page.getPdfObject()).getIndirectReference());
    }

    public PdfMcr findMcrByMcid(PdfDictionary pageDict, int mcid) {
        Map pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        return pageMcrs != null ? (PdfMcr)pageMcrs.get(mcid) : null;
    }

    public PdfObjRef findObjRefByStructParentIndex(PdfDictionary pageDict, int structParentIndex) {
        Map pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        return pageMcrs != null ? (PdfObjRef)pageMcrs.get(ParentTreeHandler.structParentIndexIntoKey(structParentIndex)) : null;
    }

    public int getNextMcidForPage(PdfPage page) {
        TreeMap<Integer, PdfMcr> pageMcrs = this.pageToPageMcrs.get(((PdfDictionary)page.getPdfObject()).getIndirectReference());
        if (pageMcrs == null || pageMcrs.isEmpty()) {
            return 0;
        }
        int lastKey = pageMcrs.lastKey();
        if (lastKey < 0) {
            return 0;
        }
        return lastKey + 1;
    }

    public void createParentTreeEntryForPage(PdfPage page) {
        Map<Integer, PdfMcr> mcrs = this.getPageMarkedContentReferences(page);
        if (mcrs == null) {
            return;
        }
        this.pageToPageMcrs.remove(((PdfDictionary)page.getPdfObject()).getIndirectReference());
        this.updateStructParentTreeEntries(page.getStructParentIndex(), mcrs);
    }

    public PdfDictionary buildParentTree() {
        return this.parentTree.buildTree().makeIndirect(this.structTreeRoot.getDocument());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerMcr(PdfMcr mcr) {
        TreeMap<Integer, PdfMcr> pageMcrs = this.pageToPageMcrs.get(mcr.getPageObject().getIndirectReference());
        if (pageMcrs == null) {
            pageMcrs = new TreeMap();
            this.pageToPageMcrs.put(mcr.getPageObject().getIndirectReference(), pageMcrs);
        }
        if (mcr instanceof PdfObjRef) {
            PdfDictionary obj = ((PdfDictionary)mcr.getPdfObject()).getAsDictionary(PdfName.Obj);
            if (obj == null || obj.isFlushed()) {
                throw new PdfException("when.adding.object.reference.to.the.tag.tree.it.must.be.connected.to.not.flushed.object");
            }
            PdfNumber n = obj.getAsNumber(PdfName.StructParent);
            if (n == null) throw new PdfException("struct.parent.index.not.found.in.tagged.object");
            pageMcrs.put(ParentTreeHandler.structParentIndexIntoKey(n.intValue()), mcr);
            return;
        } else {
            pageMcrs.put(mcr.getMcid(), mcr);
        }
    }

    public void unregisterMcr(PdfMcr mcrToUnregister) {
        PdfDictionary pageDict = mcrToUnregister.getPageObject();
        if (pageDict.isFlushed()) {
            throw new PdfException("cannot.remove.marked.content.reference.because.its.page.was.already.flushed");
        }
        Map pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        if (pageMcrs != null) {
            if (mcrToUnregister instanceof PdfObjRef) {
                PdfNumber n;
                PdfDictionary obj = ((PdfDictionary)mcrToUnregister.getPdfObject()).getAsDictionary(PdfName.Obj);
                if (obj != null && !obj.isFlushed() && (n = obj.getAsNumber(PdfName.StructParent)) != null) {
                    pageMcrs.remove(ParentTreeHandler.structParentIndexIntoKey(n.intValue()));
                    return;
                }
                Integer keyToRemove = null;
                for (Map.Entry entry : pageMcrs.entrySet()) {
                    if (((PdfMcr)entry.getValue()).getPdfObject() != mcrToUnregister.getPdfObject()) continue;
                    keyToRemove = (Integer)entry.getKey();
                    break;
                }
                if (keyToRemove != null) {
                    pageMcrs.remove(keyToRemove);
                }
            } else {
                pageMcrs.remove(mcrToUnregister.getMcid());
            }
        }
    }

    private static Integer structParentIndexIntoKey(int structParentIndex) {
        return -structParentIndex - 1;
    }

    private static int keyIntoStructParentIndex(Integer key) {
        return -key.intValue() - 1;
    }

    private void registerAllMcrs() {
        this.pageToPageMcrs = new HashMap<PdfIndirectReference, TreeMap<Integer, PdfMcr>>();
        Map<Integer, PdfObject> parentTreeEntries = new PdfNumTree(this.structTreeRoot.getDocument().getCatalog(), PdfName.ParentTree).getNumbers();
        HashSet<PdfStructElem> mcrParents = new HashSet<PdfStructElem>();
        int maxStructParentIndex = -1;
        for (Map.Entry<Integer, PdfObject> entry : parentTreeEntries.entrySet()) {
            PdfObject entryValue;
            if (entry.getKey() > maxStructParentIndex) {
                maxStructParentIndex = entry.getKey();
            }
            if ((entryValue = entry.getValue()).isDictionary()) {
                mcrParents.add(new PdfStructElem((PdfDictionary)entryValue));
                continue;
            }
            if (!entryValue.isArray()) continue;
            PdfArray parentsArray = (PdfArray)entryValue;
            for (int i = 0; i < parentsArray.size(); ++i) {
                PdfDictionary parent = parentsArray.getAsDictionary(i);
                if (parent == null) continue;
                mcrParents.add(new PdfStructElem(parent));
            }
        }
        ((PdfDictionary)this.structTreeRoot.getPdfObject()).put(PdfName.ParentTreeNextKey, new PdfNumber(maxStructParentIndex + 1));
        for (PdfStructElem mcrParent : mcrParents) {
            for (IPdfStructElem kid : mcrParent.getKids()) {
                if (!(kid instanceof PdfMcr)) continue;
                this.registerMcr((PdfMcr)kid);
            }
        }
    }

    private void updateStructParentTreeEntries(Integer pageStructParentIndex, Map<Integer, PdfMcr> mcrs) {
        PdfArray parentsOfPageMcrs = new PdfArray();
        int currentMcid = 0;
        for (Map.Entry<Integer, PdfMcr> entry : mcrs.entrySet()) {
            PdfMcr mcr = entry.getValue();
            if (mcr instanceof PdfObjRef) {
                Integer structParent = ParentTreeHandler.keyIntoStructParentIndex(entry.getKey());
                this.parentTree.addEntry(structParent, (PdfObject)((PdfStructElem)mcr.getParent()).getPdfObject());
                continue;
            }
            while (currentMcid++ < mcr.getMcid()) {
                parentsOfPageMcrs.add(PdfNull.PDF_NULL);
            }
            parentsOfPageMcrs.add((PdfObject)((PdfStructElem)mcr.getParent()).getPdfObject());
        }
        if (!parentsOfPageMcrs.isEmpty()) {
            parentsOfPageMcrs.makeIndirect(this.structTreeRoot.getDocument());
            this.parentTree.addEntry(pageStructParentIndex, parentsOfPageMcrs);
            parentsOfPageMcrs.flush();
        }
    }
}

