/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emfplus;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hemf.draw.HemfDrawProperties;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emf.HemfFill;
import org.apache.poi.hemf.record.emfplus.HemfPlusImage;
import org.apache.poi.hemf.record.emfplus.HemfPlusMisc;
import org.apache.poi.hemf.record.emfplus.HemfPlusObject;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecord;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecordType;
import org.apache.poi.hwmf.record.HwmfBrushStyle;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfMisc;
import org.apache.poi.hwmf.record.HwmfTernaryRasterOp;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordJsonWriter;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.StringUtil;

public class HemfPlusDraw {
    private static final int MAX_OBJECT_SIZE = 1000000;

    static double round10(double d) {
        return new BigDecimal(d).setScale(10, 4).doubleValue();
    }

    static int readRectS(LittleEndianInputStream leis, Rectangle2D bounds) {
        short x = leis.readShort();
        short y = leis.readShort();
        short width = leis.readShort();
        short height = leis.readShort();
        bounds.setRect(x, y, width, height);
        return 8;
    }

    static int readRectF(LittleEndianInputStream leis, Rectangle2D bounds) {
        double x = leis.readFloat();
        double y = leis.readFloat();
        double width = leis.readFloat();
        double height = leis.readFloat();
        bounds.setRect(x, y, width, height);
        return 16;
    }

    static int readPointS(LittleEndianInputStream leis, Point2D point) {
        double x = leis.readShort();
        double y = leis.readShort();
        point.setLocation(x, y);
        return 4;
    }

    static int readPointF(LittleEndianInputStream leis, Point2D point) {
        double x = leis.readFloat();
        double y = leis.readFloat();
        point.setLocation(x, y);
        return 8;
    }

    static int readPointR(LittleEndianInputStream leis, Point2D point) {
        int[] p = new int[]{0};
        int size = HemfPlusDraw.readEmfPlusInteger(leis, p);
        double x = p[0];
        double y = p[0];
        point.setLocation(x, y);
        return size += HemfPlusDraw.readEmfPlusInteger(leis, p);
    }

    private static int readEmfPlusInteger(LittleEndianInputStream leis, int[] value) {
        value[0] = leis.readByte();
        if ((value[0] & 0x80) == 0) {
            return 1;
        }
        value[0] = (value[0] << 8 | leis.readByte()) & Short.MAX_VALUE;
        return 2;
    }

    static Color readARGB(int argb) {
        return new Color(argb >>> 16 & 0xFF, argb >>> 8 & 0xFF, argb & 0xFF, argb >>> 24 & 0xFF);
    }

    public static class EmfPlusDrawRects
    implements HemfPlusRecord,
    HemfPlusMisc.EmfPlusObjectId,
    EmfPlusCompressed {
        private int flags;
        private final List<Rectangle2D> rectData = new ArrayList<Rectangle2D>();

        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.drawRects;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
            this.flags = flags;
            int count = leis.readInt();
            int size = 4;
            BiFunction readRect = this.getReadRect();
            for (int i = 0; i < count; ++i) {
                Rectangle2D.Double rect = new Rectangle2D.Double();
                size += ((Integer)readRect.apply(leis, rect)).intValue();
            }
            return size;
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"flags", this::getFlags, (String)"rectData", () -> this.rectData);
        }
    }

    public static class EmfPlusDrawDriverString
    implements HemfPlusRecord,
    HemfPlusMisc.EmfPlusObjectId,
    EmfPlusSolidColor {
        private static final BitField CMAP_LOOKUP = BitFieldFactory.getInstance((int)1);
        private static final BitField VERTICAL = BitFieldFactory.getInstance((int)2);
        private static final BitField REALIZED_ADVANCE = BitFieldFactory.getInstance((int)4);
        private static final BitField LIMIT_SUBPIXEL = BitFieldFactory.getInstance((int)8);
        private static final int[] OPTIONS_MASK = new int[]{1, 2, 4, 8};
        private static final String[] OPTIONS_NAMES = new String[]{"CMAP_LOOKUP", "VERTICAL", "REALIZED_ADVANCE", "LIMIT_SUBPIXEL"};
        private int flags;
        private int brushId;
        private int optionsFlags;
        private String glyphs;
        private final List<Point2D> glpyhPos = new ArrayList<Point2D>();
        private final AffineTransform transformMatrix = new AffineTransform();

        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.drawDriverstring;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public int getBrushIdValue() {
            return this.brushId;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
            this.flags = flags;
            this.brushId = leis.readInt();
            this.optionsFlags = leis.readInt();
            boolean hasMatrix = leis.readInt() == 1;
            int glyphCount = leis.readInt();
            int size = 16;
            byte[] glyphBuf = IOUtils.toByteArray((InputStream)leis, (long)(glyphCount * 2), (int)1000000);
            this.glyphs = StringUtil.getFromUnicodeLE((byte[])glyphBuf);
            size += glyphBuf.length;
            int glyphPosCnt = REALIZED_ADVANCE.isSet(this.optionsFlags) ? 1 : glyphCount;
            for (int i = 0; i < glyphCount; ++i) {
                Point2D.Double p = new Point2D.Double();
                size += HemfPlusDraw.readPointF(leis, p);
                this.glpyhPos.add(p);
            }
            if (hasMatrix) {
                size += HemfFill.readXForm(leis, this.transformMatrix);
            }
            return size;
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"flags", this::getFlags, (String)"brushId", this::getBrushId, (String)"optionsFlags", (Supplier)GenericRecordUtil.getBitsAsString(() -> this.optionsFlags, (int[])OPTIONS_MASK, (String[])OPTIONS_NAMES), (String)"glyphs", () -> this.glyphs, (String)"glyphPos", () -> this.glpyhPos, (String)"transform", () -> this.transformMatrix);
        }
    }

    public static class EmfPlusFillPath
    extends EmfPlusFillRegion {
        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.fillPath;
        }
    }

    public static class EmfPlusFillRegion
    implements HemfPlusRecord,
    EmfPlusSolidColor,
    HemfPlusMisc.EmfPlusObjectId {
        private int flags;
        private int brushId;

        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.fillRegion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public int getBrushIdValue() {
            return this.brushId;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
            this.flags = flags;
            this.brushId = leis.readInt();
            return 4L;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            this.applyColor(ctx);
            ctx.applyObjectTableEntry(this.getObjectId());
            HemfDrawProperties prop = ctx.getProperties();
            ctx.fill(prop.getPath());
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"flags", this::getFlags, (String)"brushId", () -> this.brushId);
        }
    }

    public static class EmfPlusDrawImage
    implements HemfPlusRecord,
    HemfPlusMisc.EmfPlusObjectId,
    EmfPlusCompressed {
        private int flags;
        private int imageAttributesID;
        private EmfPlusUnitType srcUnit;
        private final Rectangle2D srcRect = new Rectangle2D.Double();
        private final Rectangle2D rectData = new Rectangle2D.Double();

        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.drawImage;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
            this.flags = flags;
            this.imageAttributesID = leis.readInt();
            this.srcUnit = EmfPlusUnitType.valueOf(leis.readInt());
            assert (this.srcUnit == EmfPlusUnitType.Pixel);
            int size = 8;
            size += HemfPlusDraw.readRectF(leis, this.srcRect);
            return size += ((Integer)this.getReadRect().apply(leis, this.rectData)).intValue();
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.applyObjectTableEntry(this.imageAttributesID);
            ctx.applyObjectTableEntry(this.getObjectId());
            HemfDrawProperties prop = ctx.getProperties();
            prop.setRasterOp(HwmfTernaryRasterOp.SRCCOPY);
            prop.setBkMode(HwmfMisc.WmfSetBkMode.HwmfBkMode.TRANSPARENT);
            ctx.drawImage(prop.getEmfPlusImage(), this.srcRect, this.rectData);
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"flags", this::getFlags, (String)"imageAttributesID", () -> this.imageAttributesID, (String)"srcUnit", () -> this.srcUnit, (String)"srcRect", () -> this.srcRect, (String)"rectData", () -> this.rectData);
        }
    }

    public static class EmfPlusDrawImagePoints
    implements HemfPlusRecord,
    HemfPlusMisc.EmfPlusObjectId,
    EmfPlusCompressed,
    EmfPlusRelativePosition {
        private static final BitField EFFECT = BitFieldFactory.getInstance((int)8192);
        private int flags;
        private int imageAttributesID;
        private EmfPlusUnitType srcUnit;
        private final Rectangle2D srcRect = new Rectangle2D.Double();
        private final Point2D upperLeft = new Point2D.Double();
        private final Point2D lowerRight = new Point2D.Double();
        private final Point2D lowerLeft = new Point2D.Double();
        private final AffineTransform trans = new AffineTransform();

        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.drawImagePoints;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
            this.flags = flags;
            this.imageAttributesID = leis.readInt();
            this.srcUnit = EmfPlusUnitType.valueOf(leis.readInt());
            assert (this.srcUnit == EmfPlusUnitType.Pixel);
            int size = 8;
            size += HemfPlusDraw.readRectF(leis, this.srcRect);
            int count = leis.readInt();
            assert (count == 3);
            size += 4;
            BiFunction<LittleEndianInputStream, Point2D, Integer> readPoint = this.isRelativePosition() ? HemfPlusDraw::readPointR : (this.isCompressed() ? HemfPlusDraw::readPointS : HemfPlusDraw::readPointF);
            size += readPoint.apply(leis, this.lowerLeft).intValue();
            size += readPoint.apply(leis, this.lowerRight).intValue();
            size += readPoint.apply(leis, this.upperLeft).intValue();
            RealMatrix para2normal = MatrixUtils.createRealMatrix((double[][])new double[][]{{this.lowerLeft.getX(), this.lowerRight.getX(), this.upperLeft.getX()}, {this.lowerLeft.getY(), this.lowerRight.getY(), this.upperLeft.getY()}, {1.0, 1.0, 1.0}});
            RealMatrix rect2normal = MatrixUtils.createRealMatrix((double[][])new double[][]{{this.srcRect.getMinX(), this.srcRect.getMaxX(), this.srcRect.getMinX()}, {this.srcRect.getMinY(), this.srcRect.getMinY(), this.srcRect.getMaxY()}, {1.0, 1.0, 1.0}});
            RealMatrix normal2rect = new LUDecomposition(rect2normal).getSolver().getInverse();
            double[][] m = para2normal.multiply(normal2rect).getData();
            this.trans.setTransform(HemfPlusDraw.round10(m[0][0]), HemfPlusDraw.round10(m[1][0]), HemfPlusDraw.round10(m[0][1]), HemfPlusDraw.round10(m[1][1]), HemfPlusDraw.round10(m[0][2]), HemfPlusDraw.round10(m[1][2]));
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void draw(HemfGraphics ctx) {
            HemfDrawProperties prop = ctx.getProperties();
            ctx.applyObjectTableEntry(this.imageAttributesID);
            ctx.applyObjectTableEntry(this.getObjectId());
            AffineTransform txSaved = ctx.getTransform();
            AffineTransform tx = new AffineTransform(txSaved);
            try {
                tx.concatenate(this.trans);
                ctx.setTransform(tx);
                HemfPlusObject.EmfPlusObject imgObj = (HemfPlusObject.EmfPlusObject)ctx.getObjectTableEntry(this.getObjectId());
                HemfPlusImage.EmfPlusImage img = (HemfPlusImage.EmfPlusImage)imgObj.getObjectData();
                Rectangle2D srcBounds = img.getBounds(imgObj.getContinuedObject());
                BufferedImage bi = prop.getEmfPlusImage();
                prop.setRasterOp(HwmfTernaryRasterOp.SRCCOPY);
                prop.setBkMode(HwmfMisc.WmfSetBkMode.HwmfBkMode.TRANSPARENT);
                AffineTransform srcTx = new AffineTransform();
                srcTx.translate(-srcBounds.getX(), srcBounds.getY());
                srcTx.scale((double)bi.getWidth() / srcBounds.getWidth(), (double)bi.getHeight() / srcBounds.getHeight());
                srcTx.translate(bi.getMinX(), bi.getMinY());
                Rectangle2D biRect = srcTx.createTransformedShape(this.srcRect).getBounds2D();
                Rectangle2D.Double destRect = new Rectangle2D.Double(0.0, 0.0, biRect.getWidth(), biRect.getHeight());
                ctx.drawImage(bi, this.srcRect, destRect);
            }
            finally {
                ctx.setTransform(txSaved);
            }
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            LinkedHashMap<String, Supplier<Object>> m = new LinkedHashMap<String, Supplier<Object>>();
            m.put("flags", this::getFlags);
            m.put("imageAttributesID", () -> this.imageAttributesID);
            m.put("srcUnit", () -> this.srcUnit);
            m.put("srcRect", () -> this.srcRect);
            m.put("upperLeft", () -> this.upperLeft);
            m.put("lowerLeft", () -> this.lowerLeft);
            m.put("lowerRight", () -> this.lowerRight);
            m.put("transform", () -> this.trans);
            return Collections.unmodifiableMap(m);
        }
    }

    public static class EmfPlusFillRects
    implements HemfPlusRecord,
    EmfPlusCompressed,
    EmfPlusSolidColor {
        private int flags;
        private int brushId;
        private final ArrayList<Rectangle2D> rectData = new ArrayList();

        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.fillRects;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
            this.flags = flags;
            this.brushId = leis.readInt();
            int count = leis.readInt();
            BiFunction readRect = this.getReadRect();
            this.rectData.ensureCapacity(count);
            int size = 8;
            for (int i = 0; i < count; ++i) {
                Rectangle2D.Double rect = new Rectangle2D.Double();
                size += ((Integer)readRect.apply(leis, rect)).intValue();
                this.rectData.add(rect);
            }
            return size;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            this.applyColor(ctx);
            Area area = new Area();
            this.rectData.stream().map(Area::new).forEach(area::add);
            ctx.fill(area);
        }

        @Override
        public int getBrushIdValue() {
            return this.brushId;
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public HemfPlusRecordType getGenericRecordType() {
            return this.getEmfPlusRecordType();
        }

        public List<Rectangle2D> getRectData() {
            return this.rectData;
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"flags", this::getFlags, (String)"brushId", this::getBrushId, (String)"rectData", this::getRectData);
        }
    }

    public static class EmfPlusDrawPath
    implements HemfPlusRecord,
    HemfPlusMisc.EmfPlusObjectId {
        private int flags;
        private int penId;

        @Override
        public HemfPlusRecordType getEmfPlusRecordType() {
            return HemfPlusRecordType.drawPath;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        public int getPenId() {
            return this.penId;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
            this.flags = flags;
            this.penId = leis.readInt();
            assert (0 <= this.penId && this.penId <= 63);
            assert (dataSize == 4L);
            return 4L;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.applyObjectTableEntry(this.penId);
            ctx.applyObjectTableEntry(this.getObjectId());
            HemfDrawProperties prop = ctx.getProperties();
            Path2D path = prop.getPath();
            if (path != null) {
                ctx.draw(path);
            }
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal((GenericRecord)this);
        }

        public HemfPlusRecordType getGenericRecordType() {
            return this.getEmfPlusRecordType();
        }

        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties((String)"flags", this::getFlags, (String)"penId", this::getPenId);
        }
    }

    public static interface EmfPlusSolidColor {
        public static final BitField SOLID_COLOR = BitFieldFactory.getInstance((int)32768);

        public int getFlags();

        public int getBrushIdValue();

        default public boolean isSolidColor() {
            return SOLID_COLOR.isSet(this.getFlags());
        }

        default public int getBrushId() {
            return this.isSolidColor() ? -1 : this.getBrushIdValue();
        }

        default public Color getSolidColor() {
            return this.isSolidColor() ? HemfPlusDraw.readARGB(this.getBrushIdValue()) : null;
        }

        default public void applyColor(HemfGraphics ctx) {
            HemfDrawProperties prop = ctx.getProperties();
            if (this.isSolidColor()) {
                prop.setBrushStyle(HwmfBrushStyle.BS_SOLID);
                prop.setBrushColor(new HwmfColorRef(this.getSolidColor()));
            } else {
                ctx.applyObjectTableEntry(this.getBrushId());
            }
        }
    }

    public static interface EmfPlusRelativePosition {
        public static final BitField POSITION = BitFieldFactory.getInstance((int)2048);

        public int getFlags();

        default public boolean isRelativePosition() {
            return POSITION.isSet(this.getFlags());
        }
    }

    public static interface EmfPlusCompressed {
        public static final BitField COMPRESSED = BitFieldFactory.getInstance((int)16384);

        public int getFlags();

        default public boolean isCompressed() {
            return COMPRESSED.isSet(this.getFlags());
        }

        default public BiFunction<LittleEndianInputStream, Rectangle2D, Integer> getReadRect() {
            return this.isCompressed() ? HemfPlusDraw::readRectS : HemfPlusDraw::readRectF;
        }
    }

    public static enum EmfPlusUnitType {
        World(0),
        Display(1),
        Pixel(2),
        Point(3),
        Inch(4),
        Document(5),
        Millimeter(6);

        public final int id;

        private EmfPlusUnitType(int id) {
            this.id = id;
        }

        public static EmfPlusUnitType valueOf(int id) {
            for (EmfPlusUnitType wrt : EmfPlusUnitType.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }
}

