/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.output;

import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;

public class PrinterOutputStream
extends PipedOutputStream {
    private final PipedInputStream pipedInputStream;
    private final Thread threadPrint;

    public PrinterOutputStream(PrintService printService) throws IOException {
        Thread.UncaughtExceptionHandler uncaughtException = (t, e) -> Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        this.pipedInputStream = new PipedInputStream();
        super.connect(this.pipedInputStream);
        Runnable runnablePrint = () -> {
            try {
                DocFlavor.INPUT_STREAM df = DocFlavor.INPUT_STREAM.AUTOSENSE;
                SimpleDoc d = new SimpleDoc(this.pipedInputStream, df, null);
                DocPrintJob job = printService.createPrintJob();
                job.print(d, null);
            }
            catch (PrintException ex) {
                throw new RuntimeException(ex);
            }
        };
        this.threadPrint = new Thread(runnablePrint);
        this.threadPrint.setUncaughtExceptionHandler(uncaughtException);
        this.threadPrint.start();
    }

    public PrinterOutputStream() throws IOException {
        this(PrinterOutputStream.getDefaultPrintService());
    }

    public void setUncaughtException(Thread.UncaughtExceptionHandler uncaughtException) {
        this.threadPrint.setUncaughtExceptionHandler(uncaughtException);
    }

    public static String[] getListPrintServicesNames() {
        PrintService[] printServices = PrinterJob.lookupPrintServices();
        String[] printServicesNames = new String[printServices.length];
        for (int i = 0; i < printServices.length; ++i) {
            printServicesNames[i] = printServices[i].getName();
        }
        return printServicesNames;
    }

    public static PrintService getDefaultPrintService() {
        PrintService foundService = PrintServiceLookup.lookupDefaultPrintService();
        if (foundService == null) {
            throw new IllegalArgumentException("Default Print Service is not found");
        }
        return foundService;
    }

    public static PrintService getPrintServiceByName(String printServiceName) {
        PrintService[] printServices = PrinterJob.lookupPrintServices();
        PrintService foundService = null;
        for (PrintService service : printServices) {
            if (service.getName().compareTo(printServiceName) != 0) continue;
            foundService = service;
            break;
        }
        if (foundService != null) {
            return foundService;
        }
        for (PrintService service : printServices) {
            if (service.getName().compareToIgnoreCase(printServiceName) != 0) continue;
            foundService = service;
            break;
        }
        if (foundService != null) {
            return foundService;
        }
        for (PrintService service : printServices) {
            if (!service.getName().toLowerCase().contains(printServiceName.toLowerCase())) continue;
            foundService = service;
            break;
        }
        if (foundService == null) {
            throw new IllegalArgumentException("printServiceName is not found");
        }
        return foundService;
    }
}

