/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.escpos;

import com.github.anastaciocintra.escpos.EscPosConst;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PrintModeStyle
implements EscPosConst {
    private FontName fontName;
    private boolean bold;
    private boolean underline;
    private boolean doubleWidth;
    private boolean doubleHeight;
    private EscPosConst.Justification justification;

    public PrintModeStyle() {
        this.reset();
    }

    public PrintModeStyle(PrintModeStyle another) {
        this.setFontName(another.fontName);
        this.setBold(another.bold);
        this.setFontSize(another.doubleWidth, another.doubleHeight);
        this.setUnderline(another.underline);
        this.setJustification(another.justification);
    }

    public final void reset() {
        this.fontName = FontName.Font_A_Default;
        this.setBold(false);
        this.setFontSize(false, false);
        this.justification = EscPosConst.Justification.Left_Default;
    }

    public final PrintModeStyle setFontName(FontName fontName) {
        this.fontName = fontName;
        return this;
    }

    public final PrintModeStyle setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public final PrintModeStyle setFontSize(boolean doubleWidth, boolean doubleHeight) {
        this.doubleWidth = doubleWidth;
        this.doubleHeight = doubleHeight;
        return this;
    }

    public final PrintModeStyle setUnderline(boolean underline) {
        this.underline = underline;
        return this;
    }

    public final PrintModeStyle setJustification(EscPosConst.Justification justification) {
        this.justification = justification;
        return this;
    }

    public byte[] getConfigBytes() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int nVal = this.fontName.value;
        if (this.bold) {
            nVal |= 8;
        }
        if (this.doubleHeight) {
            nVal |= 0x10;
        }
        if (this.doubleWidth) {
            nVal |= 0x20;
        }
        if (this.underline) {
            nVal |= 0x80;
        }
        bytes.write(27);
        bytes.write(33);
        bytes.write(nVal);
        bytes.write(27);
        bytes.write(97);
        bytes.write(this.justification.value);
        return bytes.toByteArray();
    }

    public static enum FontName {
        Font_A_Default(0),
        Font_B(1);

        public int value;

        private FontName(int value) {
            this.value = value;
        }
    }
}

