/*
 * Decompiled with CFR 0.152.
 */
package PageRoutes.kotprint;

import Controller.Package_Printing.EposPrintingInterface;
import PageRoutes.voidprint.VoidPrint;
import Utility.StaticObjects;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.image.BitImageWrapper;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.BitonalOrderedDither;
import com.github.anastaciocintra.escpos.image.CoffeeImage;
import com.github.anastaciocintra.escpos.image.CoffeeImageImpl;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import com.github.anastaciocintra.output.PrinterOutputStream;
import com.github.anastaciocintra.output.TcpIpOutputStream;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import org.json.JSONObject;
import vmenuprintserver.StaticData;

public class VPOSConsolKotPrint
implements HttpHandler {
    @Override
    public void handle(HttpExchange he) throws IOException {
        block20: {
            boolean networkPrinterStatus = false;
            try {
                String strCurrentLine;
                String data = "";
                InputStreamReader isr = new InputStreamReader(he.getRequestBody(), "utf-8");
                BufferedReader br = new BufferedReader(isr);
                while ((strCurrentLine = br.readLine()) != null) {
                    data = data + strCurrentLine;
                }
                JSONObject obj = new JSONObject(data);
                String LOGIN_PASS = obj.getString("LOGIN_PASS");
                if (LOGIN_PASS.contentEquals(StaticData.printServerLoginPass)) {
                    String printermode = obj.getString("PRINTER_TYPE");
                    String printer = obj.getString("PRINTER_IP");
                    int portno = obj.getInt("PRINTER_PORTNO");
                    int printersize = obj.getInt("PAPER_SIZE");
                    int transactionid = obj.getInt("TRANSACTIONID");
                    int PRINT_COPY_NO = obj.getInt("PRINT_COPY_NO");
                    EscPos escpos = null;
                    if (printermode != null) {
                        if (printermode.contentEquals("USB")) {
                            PrintService printService = PrinterOutputStream.getPrintServiceByName((String)printer);
                            PrinterOutputStream printerOutputStream = new PrinterOutputStream(printService);
                            escpos = new EscPos((OutputStream)printerOutputStream);
                            printerOutputStream.setUncaughtException((t, e) -> {
                                try {
                                    StaticData.ServerResponce(400, e.getMessage(), he);
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(VoidPrint.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            networkPrinterStatus = true;
                        } else if (StaticData.PrinterOnlineOrNot(printer, portno)) {
                            TcpIpOutputStream tcp = new TcpIpOutputStream(printer, portno);
                            tcp.setUncaughtException((t, e) -> {
                                try {
                                    StaticData.ServerResponce(400, e.getMessage(), he);
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(VoidPrint.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            escpos = new EscPos((OutputStream)tcp);
                            networkPrinterStatus = true;
                        }
                        if (networkPrinterStatus) {
                            boolean mysqlsts = false;
                            try {
                                mysqlsts = StaticObjects.Server_conn.isValid(2000);
                            }
                            catch (SQLException ex) {
                                Logger.getLogger(VoidPrint.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            if (!mysqlsts) {
                                while (true) {
                                    try {
                                        StaticData.GetDbinfo();
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    if (StaticObjects.Server_conn.isValid(3000)) break;
                                    Thread.sleep(1000L);
                                }
                            }
                            int PAGE_FULLWIDTH_FONT_A = 0;
                            PAGE_FULLWIDTH_FONT_A = printersize == 0 ? 49 : 41;
                            EposPrintingInterface eposMethods = new EposPrintingInterface();
                            BitImageWrapper imageWrapper = new BitImageWrapper();
                            imageWrapper.setJustification(EscPosConst.Justification.Center);
                            BufferedImage img = ImageIO.read(new File(StaticData.defaulticonpath + "kot.png"));
                            BitonalOrderedDither algorithm = new BitonalOrderedDither();
                            EscPosImage escposImage = new EscPosImage((CoffeeImage)new CoffeeImageImpl(img), (Bitonal)algorithm);
                            escpos.write((ImageWrapperInterface)imageWrapper, escposImage);
                            ResultSet rs = StaticData.SERVER_TableSelection_SELECTION("select billno,ifnull(employeename,'') as employeename,date(billingtime) as date,time(billingtime) as time from svr_invoiceparent a inner join svr_employeeparent on empid=employeeid where invoiceid=" + transactionid);
                            rs.next();
                            if (PRINT_COPY_NO == 0) {
                                escpos.write(new Style().setJustification(EscPosConst.Justification.Center).setColorMode(Style.ColorMode.WhiteOnBlack).setBold(true).setFontName(Style.FontName.Font_B).setFontSize(Style.FontSize._2, Style.FontSize._2), "CONSOL KOT " + rs.getInt("billno"));
                            } else {
                                escpos.write(new Style().setJustification(EscPosConst.Justification.Center).setColorMode(Style.ColorMode.WhiteOnBlack).setBold(true).setFontName(Style.FontName.Font_B).setFontSize(Style.FontSize._2, Style.FontSize._2), "CONSOL KOT " + rs.getInt("billno") + "(" + PRINT_COPY_NO + ")");
                            }
                            escpos.feed(1);
                            escpos.write(eposMethods.MultiDataSingleLine("Date : " + StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), PAGE_FULLWIDTH_FONT_A / 2, 'R'));
                            escpos.write(eposMethods.MultiDataSingleLine("Time : " + StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), PAGE_FULLWIDTH_FONT_A / 2, 'L'));
                            escpos.feed(1);
                            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Right), "Served By : " + rs.getString("employeename"));
                            escpos.feed(1);
                            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(printersize));
                            escpos.feed(1);
                            int DESCRIPTION_MAX_LEN = PAGE_FULLWIDTH_FONT_A - 20;
                            int QTY_MAX_LEN = 20;
                            if (printersize == 0) {
                                escpos.writeLF(new Style().setBold(true), "Item                         Qty");
                            } else {
                                escpos.writeLF(new Style().setBold(true), "Item                 Qty");
                            }
                            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(printersize));
                            escpos.feed(1);
                            ResultSet rst = StaticData.SERVER_TableSelection_SELECTION("select itemname,itemquantity from svr_itemparent a inner join svr_invoicechild b on itemcode=basebarcode where invoiceid=" + transactionid);
                            int count = 0;
                            while (rst.next()) {
                                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine(rst.getString("itemname"), DESCRIPTION_MAX_LEN, 'R'));
                                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine(String.valueOf(rst.getDouble("itemquantity")), QTY_MAX_LEN, 'R'));
                                escpos.feed(1);
                                ++count;
                            }
                            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(printersize));
                            escpos.feed(1);
                            escpos.write(new Style().setFontName(Style.FontName.Font_B).setJustification(EscPosConst.Justification.Left_Default), "Total Items : " + count);
                            escpos.feed(5);
                            escpos.cut(EscPos.CutMode.PART);
                            escpos.close();
                            StaticData.ServerResponce(200, "success", he);
                            break block20;
                        }
                        StaticData.ServerResponce(400, "Printer is Offline", he);
                        break block20;
                    }
                    StaticData.ServerResponce(400, "invalid Payload", he);
                    break block20;
                }
                StaticData.ServerResponce(401, "invalid Credential", he);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                StaticData.ServerResponce(400, "", he);
            }
        }
    }
}

