/*
 * Decompiled with CFR 0.152.
 */
package PageRoutes.Posduebillprint;

import Controller.Package_Printing.EposPrintingInterface;
import PageRoutes.Posduebillprint.duebillPosPrint;
import Utility.StaticObjects;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.barcode.BarCodeWrapperInterface;
import com.github.anastaciocintra.escpos.barcode.QRCode;
import com.github.anastaciocintra.escpos.image.BitImageWrapper;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.BitonalOrderedDither;
import com.github.anastaciocintra.escpos.image.CoffeeImage;
import com.github.anastaciocintra.escpos.image.CoffeeImageImpl;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import com.github.anastaciocintra.output.PrinterOutputStream;
import com.github.anastaciocintra.output.TcpIpOutputStream;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import org.json.JSONObject;
import vmenuprintserver.StaticData;
import vmenuprintserver.UpdateSettings;

public class PosDuebillPrintFormat1 {
    private Style.FontName font;
    private Style.FontSize fontwidth;
    private Style.FontSize fontheight;
    private String duebill_beepsound = "off";
    private String settings_duebill_qr_code = "off";
    private String settings_duebill_decription_next_line = "A";
    private String settings_qr_based_on_section = " ";
    private String settings_bottom_title_based_on_section = " ";
    String shopname1;
    String shopaddress1;
    String shopmobile1;
    String shopemail1;
    String shoptinno1;
    String shopimage1;
    String shopfssai1;
    private int qr_section = 0;
    private int bottom_title_section = 0;

    public void printduebill(int transactionid, String printerip, String Printertype, int PORTNO, int PAPERSIZE, int DUEBILL_PRINT_NO, int NOOFCOPY, int FLAG_INV_TRANSACTION) {
        ResultSet rs = null;
        try {
            ResultSet rs1;
            rs = StaticData.CLIENT_TableSelection_SELECTION("select data from svr_settings where name='duebill_thermalprint_beepsound'");
            if (rs.next()) {
                this.duebill_beepsound = rs.getString("data");
            }
            if ((rs = StaticData.CLIENT_TableSelection_SELECTION("select data from svr_settings where name='pos_duebill_UPI_QRcode'")).next()) {
                this.settings_duebill_qr_code = rs.getString("data");
            }
            if ((rs = StaticData.SERVER_TableSelection_SELECTION("select sts from svr_settings where name='pos_duebill_description_next_line'")).next()) {
                this.settings_duebill_decription_next_line = rs.getString("sts");
            }
            if ((rs = StaticData.SERVER_TableSelection_SELECTION("select data  from svr_settings where name='qr_based_on_section'")).next()) {
                this.settings_qr_based_on_section = rs.getString("data");
            }
            if ((rs = StaticData.SERVER_TableSelection_SELECTION("select data  from svr_settings where name='bottom_title_based_on_section'")).next()) {
                this.settings_bottom_title_based_on_section = rs.getString("data");
            }
            if ((rs1 = StaticData.CLIENT_TableSelection_SELECTION("SELECT shopname,shopmobile,shopaddress,shopemail,tinno,icon_path,ifnull(fssi,'') fssi FROM svr_shopdetailsparent where sts='A' order by shopid DESC limit 1")).next()) {
                this.shopname1 = rs1.getString("shopname");
                this.shopaddress1 = rs1.getString("shopaddress");
                this.shopmobile1 = rs1.getString("shopmobile");
                this.shopemail1 = rs1.getString("shopemail");
                this.shoptinno1 = rs1.getString("tinno");
                this.shopimage1 = rs1.getString("icon_path");
                this.shopfssai1 = rs1.getString("fssi");
            }
            String shoplogo = "";
            String shopname = "";
            String addr = "";
            String contact = "";
            String email = "";
            String shopgstno = "";
            String shopfssi = "";
            ResultSet rsh = StaticData.CLIENT_TableSelection_SELECTION("select data from svr_settings where name='pos_printheader'");
            if (rsh.next() && rsh.getString("data") != null) {
                String[] list;
                String[] stringArray = list = rsh.getString("data").split("#");
                int n = stringArray.length;
                block20: for (int i = 0; i < n; ++i) {
                    String show;
                    switch (show = stringArray[i]) {
                        case "logo": {
                            File imageFile = new File(StaticData.shopiconpath + this.shopimage1);
                            shoplogo = imageFile.exists() ? imageFile.toString() : StaticData.defaulticonpath + "defaultshop.jpg";
                        }
                        case "name": {
                            shopname = this.shopname1;
                            continue block20;
                        }
                        case "address": {
                            addr = this.shopaddress1;
                            continue block20;
                        }
                        case "contact": {
                            contact = this.shopmobile1;
                            continue block20;
                        }
                        case "email": {
                            email = this.shopemail1;
                            continue block20;
                        }
                        case "gst": {
                            shopgstno = this.shoptinno1;
                            continue block20;
                        }
                        case "fssi": {
                            shopfssi = this.shopfssai1;
                            continue block20;
                        }
                    }
                }
            }
            String footer = "";
            ResultSet rsf = StaticData.CLIENT_TableSelection_SELECTION("select ifnull(data,'') as data from svr_settings where name='pos_printfooter'");
            if (rsf.next()) {
                footer = rsf.getString("data");
            }
            if (FLAG_INV_TRANSACTION == 0) {
                this.printfromORDTABLE(transactionid, printerip, Printertype, PORTNO, PAPERSIZE, DUEBILL_PRINT_NO, NOOFCOPY, FLAG_INV_TRANSACTION, shoplogo, shopname, addr, contact, email, shopgstno, footer, shopfssi);
            } else {
                this.printfromINVtable(transactionid, printerip, Printertype, PORTNO, PAPERSIZE, DUEBILL_PRINT_NO, NOOFCOPY, FLAG_INV_TRANSACTION, shoplogo, shopname, addr, contact, email, shopgstno, footer, shopfssi);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printfromORDTABLE(int transactionid, String printerip, String Printertype, int PORTNO, int PAPERSIZE, int DUEBILL_PRINT_NO, int NOOFCOPY, int FLAG_INV_TRANSACTION, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, String footer, String shopfssi) {
        String billchar = " ";
        int catering_order = 0;
        this.qr_section = 0;
        this.bottom_title_section = 0;
        try {
            ResultSet rs = StaticData.SERVER_TableSelection_SELECTION("select ifnull(b.tableno,'') as tableno,ifnull(employeename,'') as employeename,a.sectionid as sectionid,date(duebill_time) as date,time(duebill_time) as time,billdisctype,deliverychrg,cus_id,parceltype,takeawaytype,deliveryboy,tabletokenno,duebill_discount,billdisctype,advance_amt,a.delivery_date as delivery_date,a.comments as comments,a.catering_order as catering_order from ord_invoiceheader a left join svr_employeeparent on staffid=employeeid left join svr_tableparent b on a.tableno=b.tableid where transactionid=" + transactionid);
            if (rs.next()) {
                ResultSet rsp;
                int i;
                String[] list1;
                ResultSet rss1 = StaticData.SERVER_TableSelection_SELECTION("select gst from svr_sectionparent where sectionid=" + rs.getInt("sectionid"));
                rss1.next();
                if (this.settings_qr_based_on_section != null && !this.settings_qr_based_on_section.isEmpty() && !this.settings_qr_based_on_section.contentEquals(" ")) {
                    list1 = this.settings_qr_based_on_section.split("#");
                    for (i = 0; i < list1.length; ++i) {
                        if (list1[i].isEmpty() || !list1[i].contentEquals(rs.getString("sectionid"))) continue;
                        this.qr_section = rs.getInt("sectionid");
                        break;
                    }
                }
                if (this.settings_bottom_title_based_on_section != null && !this.settings_bottom_title_based_on_section.isEmpty() && !this.settings_bottom_title_based_on_section.contentEquals(" ")) {
                    list1 = this.settings_bottom_title_based_on_section.split("#");
                    for (i = 0; i < list1.length; ++i) {
                        if (list1[i].isEmpty() || !list1[i].contentEquals(rs.getString("sectionid"))) continue;
                        this.bottom_title_section = rs.getInt("sectionid");
                        break;
                    }
                }
                ResultSet rss2 = StaticData.SERVER_TableSelection_SELECTION("select billchar,tbname FROM act_taxparent where taxvalue=" + rss1.getDouble("gst"));
                rss2.next();
                if (rss2.getString("billchar") != null) {
                    billchar = rss2.getString("billchar");
                }
                catering_order = rs.getInt("catering_order");
                ResultSet rss3 = StaticData.SERVER_TableSelection_SELECTION("select id from " + rss2.getString("tbname") + " where kotno=" + transactionid);
                System.out.println("select id from " + rss2.getString("tbname") + " where kotno=" + transactionid);
                rss3.next();
                ArrayList<String> itemname = new ArrayList<String>();
                ArrayList<Double> itemqty = new ArrayList<Double>();
                ArrayList<Double> itemprice = new ArrayList<Double>();
                ArrayList<Double> taxname = new ArrayList<Double>();
                ArrayList<Double> taxtaxable = new ArrayList<Double>();
                ArrayList<Double> taxgst = new ArrayList<Double>();
                double fcesssum = 0.0;
                double cesssum = 0.0;
                double amount = 0.0;
                ResultSet rst = StaticData.SERVER_TableSelection_SELECTION("select itemname,sum(b.quantity) as qty,(sum(b.quantity)*unitprice)-(Sum(b.quantity)*discount_amt) as  total,unitprice,discount_amt,gst_type,gstper,fldcess_taxtype,fldcess_per,cess_taxtype,cess_taxper from svr_itemparent a inner join ord_invoicechild b on b.barcode=a.basebarcode where transactionid=" + transactionid + " group by   b.barcode,b.unitprice ORDER BY gstper,itemname");
                int i2 = 0;
                while (rst.next()) {
                    itemname.add(rst.getString("itemname"));
                    itemqty.add(rst.getDouble("qty"));
                    itemprice.add(rst.getDouble("unitprice"));
                    ArrayList taxarray = this.GST_Calculation(rst.getDouble("total"), rst.getString("gst_type"), rst.getDouble("gstper"), rst.getString("fldcess_taxtype"), rst.getDouble("fldcess_per"), rst.getString("cess_taxtype"), rst.getDouble("cess_taxper"));
                    if (!taxname.contains(rst.getDouble("gstper"))) {
                        taxname.add(rst.getDouble("gstper"));
                        taxtaxable.add((Double)taxarray.get(4));
                        taxgst.add((Double)taxarray.get(0));
                    } else {
                        taxtaxable.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxtaxable.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(4));
                        taxgst.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxgst.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(0));
                    }
                    if (rst.getString("cess_taxtype").contentEquals("E")) {
                        cesssum += ((Double)taxarray.get(2)).doubleValue();
                    }
                    if (rst.getString("fldcess_taxtype").contentEquals("E")) {
                        fcesssum += ((Double)taxarray.get(1)).doubleValue();
                    }
                    amount += ((Double)taxarray.get(3)).doubleValue();
                    ++i2;
                }
                double walletpoint = 0.0;
                String cusname = "";
                String cusno = "";
                String address = "";
                String tax_no = "";
                if (rs.getInt("cus_id") != 0) {
                    ResultSet rsp2 = StaticData.SERVER_TableSelection_SELECTION("SELECT customername,phone as phoneno,address,gstno,ifnull((SELECT SUM(valet_point) FROM svr_valetcardinvoice_details v WHERE v.acid=" + rs.getInt("cus_id") + "),0) as vpoint FROM svr_coustomerparent c where c.acid=" + rs.getInt("cus_id"));
                    rsp2.next();
                    cusname = rsp2.getString("customername");
                    cusno = rsp2.getString("phoneno");
                    address = rsp2.getString("address");
                    walletpoint = rsp2.getDouble("vpoint");
                    if (rsp2.getString("gstno") != null && !rsp2.getString("gstno").isEmpty()) {
                        tax_no = rsp2.getString("gstno");
                    }
                }
                double discount = 0.0;
                double roundoff = 0.0;
                if (rs.getString("billdisctype") != null) {
                    if (rs.getString("billdisctype").contentEquals("C")) {
                        discount = rs.getDouble("duebill_discount");
                    } else if (rs.getString("billdisctype").contentEquals("P")) {
                        discount = amount * rs.getDouble("duebill_discount") / 100.0;
                    }
                }
                if ((rsp = StaticData.SERVER_TableSelection_SELECTION("select roundoffvalue from temp_pos_parent where transactionid=" + transactionid)).next()) {
                    roundoff = rsp.getDouble("roundoffvalue");
                }
                String str = "";
                String table_no = null;
                if (!rs.getString("tabletokenno").isEmpty()) {
                    str = "Token No : " + rs.getString("tabletokenno");
                } else {
                    str = "Table No : " + rs.getString("tableno");
                    table_no = rs.getString("tableno");
                }
                for (int i3 = 0; i3 < NOOFCOPY; ++i3) {
                    this.EPosPrint_DueBill(FLAG_INV_TRANSACTION, NOOFCOPY, DUEBILL_PRINT_NO, transactionid, Printertype, PORTNO, printerip, PAPERSIZE, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, rs.getString("employeename"), billchar + " " + rss3.getInt("id"), itemname, itemqty, itemprice, taxname, taxtaxable, taxgst, fcesssum, cesssum, discount, rs.getDouble("deliverychrg"), roundoff, walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), transactionid, footer, shopfssi, tax_no, table_no, rss3.getString("id"), rs.getString("advance_amt"), rs.getString("delivery_date"), rs.getString("comments"), catering_order, FLAG_INV_TRANSACTION);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printfromINVtable(int invoiceid, String printerip, String Printertype, int PORTNO, int PAPERSIZE, int DUEBILL_PRINT_NO, int NOOFCOPY, int FLAG_INV_TRANSACTION, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, String footer, String shopfssi) {
        try {
            String cusname = "";
            String cusno = "";
            String address = "";
            String billchar = " ";
            String tax_no = "";
            double walletpoint = 0.0;
            this.qr_section = 0;
            ResultSet rs = StaticData.SERVER_TableSelection_SELECTION("select date(billingtime) as date,time(billingtime) as time,cus_acid,tabletokenno,t.tableno,secid,ordtakerid,billchar,billno,settlingprice,deliverychrg,roundoffvalue,parceltype,takeawaytype,deliveryboy,kotno,advance_amt,p.delivery_date as delivery_date,p.remarks as remarks from svr_invoiceparent p left join svr_tableparent t on p.tableno=tableid where invoiceid=" + invoiceid);
            if (rs.next()) {
                ResultSet rsp;
                int i;
                String[] list1;
                if (this.settings_qr_based_on_section != null && !this.settings_qr_based_on_section.isEmpty() && !this.settings_qr_based_on_section.contentEquals(" ")) {
                    list1 = this.settings_qr_based_on_section.split("#");
                    for (i = 0; i < list1.length; ++i) {
                        if (list1[i].isEmpty() || !list1[i].contentEquals(rs.getString("secid"))) continue;
                        this.qr_section = rs.getInt("secid");
                        break;
                    }
                }
                if (this.settings_bottom_title_based_on_section != null && !this.settings_bottom_title_based_on_section.isEmpty() && !this.settings_bottom_title_based_on_section.contentEquals(" ")) {
                    list1 = this.settings_bottom_title_based_on_section.split("#");
                    for (i = 0; i < list1.length; ++i) {
                        if (list1[i].isEmpty() || !list1[i].contentEquals(rs.getString("secid"))) continue;
                        this.bottom_title_section = rs.getInt("secid");
                        break;
                    }
                }
                if (rs.getString("billchar") != null) {
                    billchar = rs.getString("billchar");
                }
                if (rs.getInt("cus_acid") != 0) {
                    rsp = StaticData.SERVER_TableSelection_SELECTION("SELECT customername,phone as phoneno,address,gstno,ifnull((SELECT SUM(valet_point) FROM svr_valetcardinvoice_details v WHERE v.acid=" + rs.getInt("cus_acid") + "),0) as vpoint FROM svr_coustomerparent c where c.acid=" + rs.getInt("cus_acid"));
                    rsp.next();
                    cusname = rsp.getString("customername");
                    cusno = rsp.getString("phoneno");
                    address = rsp.getString("address");
                    walletpoint = rsp.getDouble("vpoint");
                    if (rsp.getString("gstno") != null && !rsp.getString("gstno").isEmpty()) {
                        tax_no = rsp.getString("gstno");
                    }
                } else {
                    rsp = StaticData.SERVER_TableSelection_SELECTION("SELECT acid FROM svr_valetcardinvoice_details WHERE inv_rowid=" + invoiceid + " order by id desc limit 1");
                    if (rsp.next()) {
                        rsp = StaticData.SERVER_TableSelection_SELECTION("SELECT customername,phone as phoneno,address,ifnull((SELECT SUM(valet_point) FROM svr_valetcardinvoice_details v WHERE v.acid=" + rsp.getInt("acid") + "),0) as vpoint FROM svr_coustomerparent c where c.acid=" + rsp.getInt("acid"));
                        rsp.next();
                        cusname = rsp.getString("customername");
                        cusno = rsp.getString("phoneno");
                        address = rsp.getString("address");
                        walletpoint = rsp.getDouble("vpoint");
                    }
                }
                String str = "";
                String table_no = null;
                if (!rs.getString("tabletokenno").isEmpty()) {
                    str = "Token No : " + rs.getString("tabletokenno");
                } else {
                    str = "Table No : " + rs.getString("tableno");
                    table_no = rs.getString("tableno");
                }
                String emp = "";
                if (rs.getInt("ordtakerid") != 0) {
                    ResultSet rst = StaticData.SERVER_TableSelection_SELECTION("select employeename from svr_employeeparent where employeeid=" + rs.getInt("ordtakerid"));
                    rst.next();
                    emp = rst.getString(1);
                }
                ArrayList<String> itemname = new ArrayList<String>();
                ArrayList<Double> itemqty = new ArrayList<Double>();
                ArrayList<Double> itemprice = new ArrayList<Double>();
                ArrayList<Double> taxname = new ArrayList<Double>();
                ArrayList<Double> taxtaxable = new ArrayList<Double>();
                ArrayList<Double> taxgst = new ArrayList<Double>();
                double fcesssum = 0.0;
                double cesssum = 0.0;
                double discount = 0.0;
                ResultSet rst = StaticData.SERVER_TableSelection_SELECTION("select itemname,sum(itemquantity) as  itemquantity,(sum(itemquantity)*itemprice)-(sum(itemquantity)*itemdiscount) as total,itemprice,itemdiscount,gsttype,gstper,fldcesstype,fldcessper,b.cess_type,b.cess_per from svr_itemparent a inner join svr_invoicechild b on itemcode=basebarcode where invoiceid=" + invoiceid + " group by   itemcode,itemprice ORDER BY gstper,itemname");
                int i2 = 0;
                while (rst.next()) {
                    itemname.add(rst.getString("itemname"));
                    itemqty.add(rst.getDouble("itemquantity"));
                    itemprice.add(rst.getDouble("itemprice"));
                    ArrayList taxarray = this.GST_Calculation(rst.getDouble("total"), rst.getString("gsttype"), rst.getDouble("gstper"), rst.getString("fldcesstype"), rst.getDouble("fldcessper"), rst.getString("cess_type"), rst.getDouble("cess_per"));
                    if (!taxname.contains(rst.getDouble("gstper"))) {
                        taxname.add(rst.getDouble("gstper"));
                        taxtaxable.add((Double)taxarray.get(4));
                        taxgst.add((Double)taxarray.get(0));
                    } else {
                        taxtaxable.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxtaxable.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(4));
                        taxgst.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxgst.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(0));
                    }
                    if (rst.getString("cess_type").contentEquals("E")) {
                        cesssum += ((Double)taxarray.get(2)).doubleValue();
                    }
                    if (rst.getString("fldcesstype").contentEquals("E")) {
                        fcesssum += ((Double)taxarray.get(1)).doubleValue();
                    }
                    discount += rst.getDouble("itemdiscount");
                    ++i2;
                }
                for (i2 = 0; i2 < NOOFCOPY; ++i2) {
                    this.EPosPrint_DueBill(FLAG_INV_TRANSACTION, NOOFCOPY, DUEBILL_PRINT_NO, invoiceid, Printertype, PORTNO, printerip, PAPERSIZE, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, emp, billchar + " " + rs.getInt("billno"), itemname, itemqty, itemprice, taxname, taxtaxable, taxgst, fcesssum, cesssum, rs.getDouble("settlingprice") - discount, rs.getDouble("deliverychrg"), rs.getDouble("roundoffvalue"), walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), rs.getInt("kotno"), footer, shopfssi, tax_no, table_no, rs.getString("billno"), rs.getString("advance_amt"), rs.getString("delivery_date"), rs.getString("remarks"), 0, FLAG_INV_TRANSACTION);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void EPosPrint_DueBill(int invoiceORtransactionid, int NOOFCOPY, int DUEBILL_PRINT_NO, int transactionid, String printertype, int portno, String printername, int papersize, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, String billdate, String billtime, String cusname, String cusno, String address, String t_string, String empname, String billno, ArrayList<String> itemname, ArrayList<Double> itemqty, ArrayList<Double> itemprice, ArrayList<Double> taxname, ArrayList<Double> taxtaxable, ArrayList<Double> taxgst, double fcesssum, double cesssum, double discount, double deliverychrg, double roundoff, double walletpoint, String ordermode, int takeawaytype, int deliveryboy, int kotno, String footer, String shopfssi, String tax_no, String table_no, String bill_no, String advance_amt, String delivery_date, String remarks, int catering_order, int FLAG_INV_TRANSACTION) {
        try {
            String settings_billnet_roundoff = "off";
            ResultSet rs_roundoff = StaticData.SERVER_TableSelection_SELECTION("select data from svr_settings where name='billnet_total_roundoff'");
            if (rs_roundoff.next()) {
                settings_billnet_roundoff = rs_roundoff.getString("data");
            }
            EscPos escpos = null;
            if (printertype.contentEquals("NW")) {
                if (StaticData.PrinterOnlineOrNot(printername, portno)) {
                    TcpIpOutputStream tcp = new TcpIpOutputStream(printername, portno);
                    escpos = new EscPos((OutputStream)tcp);
                }
            } else {
                PrintService printService = PrinterOutputStream.getPrintServiceByName((String)printername);
                PrinterOutputStream printerOutputStream = new PrinterOutputStream(printService);
                escpos = new EscPos((OutputStream)printerOutputStream);
            }
            escpos.initializePrinter();
            int PAGE_FULLWIDTH_FONT_A = 0;
            PAGE_FULLWIDTH_FONT_A = papersize == 80 ? 49 : 41;
            EposPrintingInterface eposMethods = new EposPrintingInterface();
            escpos.initializePrinter();
            if (!shoplogo.isEmpty()) {
                try {
                    Object imageWrapper = new BitImageWrapper();
                    imageWrapper.setJustification(EscPosConst.Justification.Center);
                    BufferedImage img = ImageIO.read(new File(shoplogo));
                    BitonalOrderedDither algorithm = new BitonalOrderedDither();
                    EscPosImage escposImage = new EscPosImage((CoffeeImage)new CoffeeImageImpl(img), (Bitonal)algorithm);
                    escpos.write((ImageWrapperInterface)imageWrapper, escposImage);
                    escpos.feed(1);
                }
                catch (Exception imageWrapper) {
                    // empty catch block
                }
            }
            if (!shopname.isEmpty()) {
                this.getFontProperties(1);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopname);
            }
            if (!shopaddr.isEmpty()) {
                this.getFontProperties(2);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopaddr);
            }
            if (!shopemail.isEmpty()) {
                this.getFontProperties(3);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopemail);
            }
            if (!shopmob.isEmpty()) {
                this.getFontProperties(4);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Ph : " + shopmob);
            }
            if (!shopgst.isEmpty()) {
                this.getFontProperties(5);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopgst);
            }
            if (!shopfssi.isEmpty()) {
                this.getFontProperties(6);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopfssi);
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DoubleDashedLine(papersize));
            this.getFontProperties(7);
            escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Date : " + billdate + " " + billtime, PAGE_FULLWIDTH_FONT_A / 2 + 1, 'R'));
            this.getFontProperties(8);
            if (catering_order != 0) {
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order No :" + catering_order, PAGE_FULLWIDTH_FONT_A / 2 - 1, 'L'));
            } else {
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Inv No : " + billno, PAGE_FULLWIDTH_FONT_A / 2 - 1, 'L'));
            }
            escpos.feed(1);
            this.getFontProperties(9);
            escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Staff : " + empname, PAGE_FULLWIDTH_FONT_A / 2 + 5, 'R'));
            this.getFontProperties(25);
            escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(t_string, PAGE_FULLWIDTH_FONT_A / 2 - 5, 'L'));
            if (delivery_date != null && !delivery_date.isEmpty()) {
                this.getFontProperties(33);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Del.Date : " + StaticObjects.vimp_utility.DateAndTimeFormatChange(delivery_date, 2, 3), PAGE_FULLWIDTH_FONT_A / 2 + 1, 'R'));
            }
            if (remarks != null && !remarks.isEmpty()) {
                this.getFontProperties(31);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Remarks:" + remarks, PAGE_FULLWIDTH_FONT_A / 2 + 1, 'L'));
            }
            escpos.feed(1);
            switch (ordermode) {
                case "I": {
                    this.getFontProperties(10);
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Dine In", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
                case "D": {
                    if (deliveryboy == 0) {
                        this.getFontProperties(10);
                        escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Delivery", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                        break;
                    }
                    this.getFontProperties(10);
                    ResultSet srs = StaticData.SERVER_TableSelection_SELECTION("select employeename from svr_employeeparent where employeeid=" + deliveryboy);
                    srs.next();
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Delivery(" + srs.getString(1) + ")", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
                case "H": {
                    if (deliveryboy == 0) {
                        this.getFontProperties(33);
                        escpos.writeLF(new Style().setFontName(this.font).setJustification(EscPosConst.Justification.Center).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Home Delivery", PAGE_FULLWIDTH_FONT_A, 'R'));
                        break;
                    }
                    this.getFontProperties(33);
                    ResultSet srs = StaticData.SERVER_TableSelection_SELECTION("select employeename from svr_employeeparent where employeeid=" + deliveryboy);
                    srs.next();
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true).setJustification(EscPosConst.Justification.Center), eposMethods.MultiDataSingleLine("Order Mode :Home Delivery(" + srs.getString(1) + ")", PAGE_FULLWIDTH_FONT_A, 'R'));
                    break;
                }
                case "T": {
                    ResultSet srs = StaticData.SERVER_TableSelection_SELECTION("select takeaway_name from svr_takeawaycharges where id=" + takeawaytype);
                    this.getFontProperties(10);
                    srs.next();
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Takeaway(" + srs.getString("takeaway_name") + ")", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
            }
            if (!cusname.isEmpty()) {
                this.getFontProperties(11);
                escpos.write("Customer : " + cusname + " (" + cusno + ")");
                escpos.feed(1);
                if (tax_no != null && !tax_no.isEmpty()) {
                    escpos.write(tax_no);
                    escpos.feed(1);
                }
                if (address != null && !address.isEmpty()) {
                    escpos.writeLF(address);
                }
            }
            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(papersize));
            escpos.feed(1);
            int SI_MAX_LEN = 2;
            int DESCRIPTION_MAX_LEN = PAGE_FULLWIDTH_FONT_A - 24;
            int QTY_MAX_LEN = 5;
            int ARP_MAX_LEN = 8;
            int TOTAL_MAX_LEN = 8;
            if (papersize == 80) {
                this.getFontProperties(29);
                escpos.writeLF(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "SL Item                        Qty  Rate  Total");
            } else {
                this.getFontProperties(29);
                escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), "SL Item                     Qty     Rate   Total");
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(papersize));
            int i = 0;
            for (i = 0; i < itemname.size(); ++i) {
                this.getFontProperties(12);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(String.valueOf(i + 1), SI_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(" " + itemname.get(i), DESCRIPTION_MAX_LEN, 'R'));
                double qnty = itemqty.get(i);
                int qty = (int)qnty;
                String qstring = "";
                qstring = qnty == (double)qty ? String.valueOf(qty) : String.valueOf(qnty);
                this.getFontProperties(27);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(qstring, QTY_MAX_LEN, 'L'));
                escpos.write(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(itemprice.get(i).doubleValue(), UpdateSettings.POSDUEBILL_numberfraction), ARP_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(itemprice.get(i) * itemqty.get(i), UpdateSettings.POSDUEBILL_numberfraction), TOTAL_MAX_LEN, 'L'));
                escpos.feed(1);
                if (!this.settings_duebill_decription_next_line.contentEquals("A") || itemname.get(i).length() <= DESCRIPTION_MAX_LEN) continue;
                this.getFontProperties(12);
                escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true).setFontName(this.font).setBold(true), "   " + itemname.get(i).substring(DESCRIPTION_MAX_LEN - 1));
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(papersize));
            double taxabletot = 0.0;
            double cgsttot = 0.0;
            double taxamttot = 0.0;
            int TAX_MAX_LEN = 12;
            int TAXABLE_MAX_LEN = 10;
            int CGST_MAX_LEN = 8;
            int TOTTAX_MAX_LEN = 9;
            if (taxname.size() != 1 || taxname.get(0) != 0.0) {
                if (papersize == 0) {
                    this.getFontProperties(30);
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), "Tax      Taxable Value    CGST   SGST Tax Amount");
                } else {
                    this.getFontProperties(30);
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), "Tax     Taxable Value    CGST SGST Tax Amount");
                }
            }
            for (int j = 0; j < taxname.size(); ++j) {
                if (taxname.size() != 1 || taxname.get(0) != 0.0) {
                    this.getFontProperties(16);
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("GST@" + taxname.get(j), TAX_MAX_LEN, 'R'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxtaxable.get(j).doubleValue(), UpdateSettings.POSDUEBILL_numberfraction), TAXABLE_MAX_LEN, 'L'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxgst.get(j) / 2.0, UpdateSettings.POSDUEBILL_numberfraction), CGST_MAX_LEN, 'L'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxgst.get(j) / 2.0, UpdateSettings.POSDUEBILL_numberfraction), CGST_MAX_LEN - 1, 'L'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxtaxable.get(j) + taxgst.get(j), UpdateSettings.POSDUEBILL_numberfraction), TOTTAX_MAX_LEN + 2, 'L'));
                    escpos.feed(1);
                }
                taxabletot += taxtaxable.get(j).doubleValue();
                cgsttot += taxgst.get(j) / 2.0;
                taxamttot += taxtaxable.get(j) + taxgst.get(j);
            }
            if (taxname.size() != 1 && taxname.get(0) != 0.0) {
                this.getFontProperties(13);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("Total", TAX_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxabletot, UpdateSettings.POSDUEBILL_numberfraction), TAXABLE_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(cgsttot, UpdateSettings.POSDUEBILL_numberfraction), CGST_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(cgsttot, UpdateSettings.POSDUEBILL_numberfraction), CGST_MAX_LEN - 1, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxamttot, UpdateSettings.POSDUEBILL_numberfraction), TOTTAX_MAX_LEN + 2, 'L'));
                escpos.feed(1);
            }
            if (cesssum != 0.0) {
                this.getFontProperties(14);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("CESS : ", PAGE_FULLWIDTH_FONT_A - TOTAL_MAX_LEN + 3, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(cesssum, UpdateSettings.POSDUEBILL_numberfraction), TOTAL_MAX_LEN - 4, 'L'));
                escpos.feed(1);
            }
            if (fcesssum != 0.0) {
                this.getFontProperties(15);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("FCESS : ", PAGE_FULLWIDTH_FONT_A - TOTAL_MAX_LEN + 3, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(fcesssum, UpdateSettings.POSDUEBILL_numberfraction), TOTAL_MAX_LEN - 4, 'L'));
                escpos.feed(1);
            }
            this.getFontProperties(17);
            escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Total Items : " + i);
            if (discount > 0.0) {
                this.getFontProperties(18);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Bill Discount : " + StaticObjects.vimp_utility.Decimalpointlength(discount, UpdateSettings.POSDUEBILL_numberfraction));
                escpos.feed(1);
            }
            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(papersize));
            escpos.feed(1);
            double nettotal = taxamttot + fcesssum + cesssum + deliverychrg - discount + roundoff;
            if (deliverychrg > 0.0) {
                this.getFontProperties(19);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Right).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Delivery Charge : " + deliverychrg);
            }
            this.getFontProperties(20);
            if (settings_billnet_roundoff.contentEquals("on")) {
                escpos.writeLF(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setJustification(EscPosConst.Justification.Right).setLineSpacing(3), "NET TOTAL : " + StaticObjects.vimp_utility.Decimalpointlength((double)Math.round(nettotal), UpdateSettings.POSDUEBILL_numberfraction));
            } else {
                escpos.writeLF(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setJustification(EscPosConst.Justification.Right).setLineSpacing(3), "NET TOTAL : " + StaticObjects.vimp_utility.Decimalpointlength(nettotal, UpdateSettings.POSDUEBILL_numberfraction));
            }
            if (Double.parseDouble(advance_amt) != 0.0 && advance_amt != null) {
                this.getFontProperties(19);
                if (FLAG_INV_TRANSACTION == 0) {
                    escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Right).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Advance Amount : " + StaticObjects.vimp_utility.Decimalpointlength(Double.parseDouble(advance_amt), UpdateSettings.POSDUEBILL_numberfraction));
                } else {
                    escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Left_Default).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Advance Amount : " + StaticObjects.vimp_utility.Decimalpointlength(Double.parseDouble(advance_amt), UpdateSettings.POSDUEBILL_numberfraction));
                }
                if (nettotal - Double.parseDouble(advance_amt) != 0.0) {
                    this.getFontProperties(20);
                    escpos.writeLF(new Style().setBold(true).setJustification(EscPosConst.Justification.Right).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Balance Amount : " + StaticObjects.vimp_utility.Decimalpointlength(nettotal - Double.parseDouble(advance_amt), UpdateSettings.POSDUEBILL_numberfraction));
                }
            }
            this.getFontProperties(28);
            escpos.writeLF(new Style().setBold(true).setFontSize(this.fontwidth, this.fontheight).setFontName(this.font).setJustification(EscPosConst.Justification.Left_Default), StaticObjects.vimp_utility.NumberToword((int)Math.round(nettotal), 2));
            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(papersize));
            escpos.feed(1);
            if (walletpoint > 0.0) {
                this.getFontProperties(21);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Loyalty Point : " + walletpoint + " coin     Point Redeemed : 0.00");
                escpos.feed(1);
            }
            this.getFontProperties(22);
            escpos.writeLF(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setJustification(EscPosConst.Justification.Left_Default), "KOT NO : " + kotno);
            escpos.feed(1);
            if (!this.settings_duebill_qr_code.contentEquals("off") && this.qr_section != 0) {
                String[] list = this.settings_duebill_qr_code.split("#");
                String qr_info = "upi://pay?pa=" + list[1] + "&pn=" + list[0] + "&am=" + StaticObjects.vimp_utility.Decimalpointlength(nettotal, UpdateSettings.POSDUEBILL_numberfraction);
                if (list.length > 2) {
                    if (list[2].contentEquals("billno")) {
                        qr_info = qr_info + "&tn=" + bill_no;
                    } else if (list[2].contentEquals("tbname")) {
                        if (table_no != null) {
                            qr_info = qr_info + "tablename:" + table_no;
                        }
                    } else if (list[2].contentEquals("cusname") && !cusname.isEmpty()) {
                        qr_info = qr_info + "customername:" + cusname;
                    }
                }
                if (list.length > 3) {
                    if (list[3].contentEquals("tbname")) {
                        if (table_no != null) {
                            qr_info = qr_info + "tablename:" + table_no;
                        }
                    } else if (list[3].contentEquals("cusname") && !cusname.isEmpty()) {
                        qr_info = qr_info + "customername:" + cusname;
                    }
                }
                if (list.length > 4 && list[4].contentEquals("cusname") && !cusname.isEmpty()) {
                    qr_info = qr_info + "customername:" + cusname;
                }
                System.out.println("------------------------");
                System.out.println(qr_info);
                QRCode cc = new QRCode();
                cc.setSize(7);
                cc.setModel(QRCode.QRModel._1_Default);
                cc.setJustification(EscPosConst.Justification.Center);
                escpos.write((BarCodeWrapperInterface)cc, qr_info);
                escpos.feed(1);
            }
            try {
                ResultSet r1 = StaticData.SERVER_TableSelection_SELECTION("select data from svr_settings where name='duebill_instruction_text'");
                if (r1.next() && !r1.getString("data").isEmpty()) {
                    this.getFontProperties(34);
                    escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), r1.getString("data"));
                    escpos.feed(4);
                }
            }
            catch (Exception r1) {
                // empty catch block
            }
            if (!footer.isEmpty() && this.bottom_title_section != 0) {
                this.getFontProperties(23);
                escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true).setJustification(EscPosConst.Justification.Center), footer);
                escpos.feed(4);
            }
            escpos.feed(4);
            escpos.cut(EscPos.CutMode.PART);
            try {
                if (this.duebill_beepsound.contentEquals("on")) {
                    byte[] beep = new byte[]{27, 66, 2, 1};
                    escpos.write(beep, 0, beep.length);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
            }
            escpos.close();
        }
        catch (Exception ex) {
            JSONObject obj = new JSONObject();
            obj.put("printertype", (Object)printertype);
            obj.put("PrinterName", (Object)printername);
            obj.put("portno", portno);
            obj.put("papersize", papersize);
            obj.put("transactionid", transactionid);
            obj.put("noofcopy", 1);
            obj.put("printno", DUEBILL_PRINT_NO);
            obj.put("invoiceORtransactionid", invoiceORtransactionid);
            duebillPosPrint.ErrorPrinters.put((Object)obj);
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ArrayList GST_Calculation(double itemtotal, String gsttype, double gstper, String fldcesstype, double fldcessper, String cesstype, double cessper) {
        if (gsttype.isEmpty()) {
            gsttype = "I";
        }
        if (fldcesstype.isEmpty()) {
            fldcesstype = "I";
        }
        if (cesstype.isEmpty()) {
            cesstype = "I";
        }
        ArrayList<Double> tax_array = new ArrayList<Double>();
        if (gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double gst = itemtotal * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = itemtotal * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = itemtotal * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + fldcess + cess);
            tax_array.add(itemtotal);
        } else if (gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + fldcess);
            tax_array.add(taxablevalue);
        } else if (gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + fldcessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + cess);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + fldcess + cess);
            tax_array.add(taxablevalue);
        } else if (gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + fldcessper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + fldcess);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + fldcessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + cess);
            tax_array.add(taxablevalue);
        } else if (!(gsttype.contentEquals("E") || fldcesstype.contentEquals("E") || cesstype.contentEquals("E"))) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + fldcessper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal);
            tax_array.add(taxablevalue);
        }
        return tax_array;
    }

    public void getFontProperties(int i) {
        this.font = Style.FontName.Font_A_Default;
        this.fontwidth = Style.FontSize._1;
        this.fontheight = Style.FontSize._1;
        try {
            ResultSet rsst = StaticData.CLIENT_TableSelection_SELECTION("select sts,data from svr_settings where name='duebill_s" + i + "font'");
            if (rsst.next()) {
                System.out.print("font pr");
                switch (rsst.getString("sts")) {
                    case "A": {
                        this.font = Style.FontName.Font_A_Default;
                        break;
                    }
                    case "B": {
                        this.font = Style.FontName.Font_B;
                        break;
                    }
                    default: {
                        this.font = Style.FontName.Font_C;
                    }
                }
                String[] list = rsst.getString("data").split("#");
                try {
                    switch (list[0]) {
                        case "1": {
                            this.fontwidth = Style.FontSize._1;
                            break;
                        }
                        case "2": {
                            this.fontwidth = Style.FontSize._2;
                            break;
                        }
                        case "3": {
                            this.fontwidth = Style.FontSize._3;
                            break;
                        }
                        case "4": {
                            this.fontwidth = Style.FontSize._4;
                            break;
                        }
                        case "5": {
                            this.fontwidth = Style.FontSize._5;
                            break;
                        }
                        case "6": {
                            this.fontwidth = Style.FontSize._6;
                            break;
                        }
                        case "7": {
                            this.fontwidth = Style.FontSize._7;
                            break;
                        }
                        default: {
                            this.fontwidth = Style.FontSize._8;
                        }
                    }
                    switch (list[1]) {
                        case "1": {
                            this.fontheight = Style.FontSize._1;
                            break;
                        }
                        case "2": {
                            this.fontheight = Style.FontSize._2;
                            break;
                        }
                        case "3": {
                            this.fontheight = Style.FontSize._3;
                            break;
                        }
                        case "4": {
                            this.fontheight = Style.FontSize._4;
                            break;
                        }
                        case "5": {
                            this.fontheight = Style.FontSize._5;
                            break;
                        }
                        case "6": {
                            this.fontheight = Style.FontSize._6;
                            break;
                        }
                        case "7": {
                            this.fontwidth = Style.FontSize._7;
                            break;
                        }
                        default: {
                            this.fontheight = Style.FontSize._8;
                            break;
                        }
                    }
                }
                catch (Exception e1x) {
                    System.out.println(e1x);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

