/*
 * Decompiled with CFR 0.152.
 */
package Package_Printing;

import Package_Printing.EposPrintingInterface;
import Package_Printing.EposTextToImageCretor;
import Utility.DbAction;
import Utility.StaticObjects;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.image.BitImageWrapper;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.BitonalOrderedDither;
import com.github.anastaciocintra.escpos.image.CoffeeImage;
import com.github.anastaciocintra.escpos.image.CoffeeImageImpl;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import com.github.anastaciocintra.output.TcpIpOutputStream;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class PosDuebillPrintFormat4ArabicThermal {
    private DbAction db = new DbAction();
    String shopname1;
    String shopaddress1;
    String shopmobile1;
    String shopemail1;
    String shoptinno1;
    String shopimage1;
    String shopfssai1;

    public void printduebill(int transactionid, int settings_numberfraction, int type, String PRINTERIP, String fileabsalutepath) {
        try {
            DbAction db = new DbAction();
            ResultSet rs = db.CLIENT_TableSelection_SELECTION("SELECT shopname,shopmobile,shopaddress,shopemail,tinno,icon_path,ifnull(fssi,'') fssi FROM svr_shopdetailsparent where sts='A' order by shopid DESC limit 1");
            if (rs.next()) {
                this.shopname1 = rs.getString("shopname");
                this.shopaddress1 = rs.getString("shopaddress");
                this.shopmobile1 = rs.getString("shopmobile");
                this.shopemail1 = rs.getString("shopemail");
                this.shoptinno1 = rs.getString("tinno");
                this.shopimage1 = rs.getString("icon_path");
                this.shopfssai1 = rs.getString("fssi");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StaticObjects.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            String shoplogo = "";
            String shopname = "";
            String addr = "";
            String contact = "";
            String email = "";
            String shopgstno = "";
            String shopfssi = "";
            ResultSet rsh = this.db.CLIENT_TableSelection_SELECTION("select data from svr_settings where name='pos_printheader'");
            if (rsh.next() && rsh.getString("data") != null) {
                String[] list;
                String[] stringArray = list = rsh.getString("data").split("#");
                int n = stringArray.length;
                block22: for (int i = 0; i < n; ++i) {
                    String show;
                    switch (show = stringArray[i]) {
                        case "logo": {
                            File imageFile = new File(fileabsalutepath + "src/resource/images/shop/" + this.shopimage1);
                            if (imageFile.exists()) {
                                shoplogo = imageFile.toString();
                                continue block22;
                            }
                            shoplogo = fileabsalutepath + "src/resource/images/defaulticon/defaultshop.jpg";
                            continue block22;
                        }
                        case "name": {
                            shopname = this.shopname1;
                            continue block22;
                        }
                        case "address": {
                            addr = this.shopaddress1;
                            continue block22;
                        }
                        case "contact": {
                            contact = this.shopmobile1;
                            continue block22;
                        }
                        case "email": {
                            email = this.shopemail1;
                            continue block22;
                        }
                        case "gst": {
                            shopgstno = this.shoptinno1;
                            continue block22;
                        }
                        case "fssi": {
                            shopfssi = this.shopfssai1;
                            continue block22;
                        }
                    }
                }
            }
            String footer = "";
            ResultSet rsf = this.db.CLIENT_TableSelection_SELECTION("select ifnull(data,'') as data from svr_settings where name='pos_printfooter'");
            if (rsf.next()) {
                footer = rsf.getString("data");
            }
            this.printType1(transactionid, shoplogo, shopname, addr, contact, email, shopgstno, settings_numberfraction, footer, shopfssi, PRINTERIP);
        }
        catch (SQLException ex) {
            Logger.getLogger(PosDuebillPrintFormat4ArabicThermal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printType1(int transactionid, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, int settings_numberfraction, String footer, String shopfssi, String PRINTERIP) {
        try {
            ResultSet rs = this.db.SERVER_TableSelection_SELECTION("select ifnull(b.tableno,'') as tableno,ifnull(employeename,'') as employeename,a.sectionid as sectionid,date(order_time) as date,time(order_time) as time,billdisctype,deliverychrg,cus_id,parceltype,takeawaytype,deliveryboy,tabletokenno,duebill_discount,billdisctype from ord_invoiceheader a left join svr_employeeparent on staffid=employeeid left join svr_tableparent b on a.tableno=b.tableid where transactionid=" + transactionid);
            if (rs.next()) {
                ResultSet rss1 = this.db.SERVER_TableSelection_SELECTION("select gst from svr_sectionparent where sectionid=" + rs.getInt("sectionid"));
                rss1.next();
                ResultSet rss2 = this.db.SERVER_TableSelection_SELECTION("select ifnull(billchar,'') billchar,tbname FROM act_taxparent where taxvalue=" + rss1.getDouble("gst"));
                rss2.next();
                ResultSet rss3 = this.db.SERVER_TableSelection_SELECTION("select id from " + rss2.getString("tbname") + " where kotno=" + transactionid);
                rss3.next();
                ArrayList<String> itemname = new ArrayList<String>();
                ArrayList<String> arabicname = new ArrayList<String>();
                ArrayList<Double> itemqty = new ArrayList<Double>();
                ArrayList<Double> itemprice = new ArrayList<Double>();
                ArrayList<Double> taxname = new ArrayList<Double>();
                ArrayList<Double> taxtaxable = new ArrayList<Double>();
                ArrayList<Double> taxgst = new ArrayList<Double>();
                double gstsumexc = 0.0;
                double gstsuminc = 0.0;
                double fcesssum = 0.0;
                double cesssum = 0.0;
                double amount = 0.0;
                double discount = 0.0;
                ResultSet rst = this.db.SERVER_TableSelection_SELECTION("select itemname,b.quantity as qty,(b.quantity*unitprice)-(b.quantity*discount_amt) as total,unitprice,discount_amt,gst_type,gstper,fldcess_taxtype,fldcess_per,cess_taxtype,cess_taxper,arabicname from svr_itemparent a inner join ord_invoicechild b on b.barcode=a.basebarcode where transactionid=" + transactionid);
                int i = 0;
                while (rst.next()) {
                    itemname.add(rst.getString("itemname"));
                    arabicname.add(rst.getString("arabicname"));
                    itemqty.add(rst.getDouble("qty"));
                    itemprice.add(rst.getDouble("unitprice"));
                    ArrayList taxarray = this.GST_Calculation(rst.getDouble("total"), rst.getString("gst_type"), rst.getDouble("gstper"), rst.getString("fldcess_taxtype"), rst.getDouble("fldcess_per"), rst.getString("cess_taxtype"), rst.getDouble("cess_taxper"));
                    if (!taxname.contains(rst.getDouble("gstper"))) {
                        taxname.add(rst.getDouble("gstper"));
                        taxtaxable.add((Double)taxarray.get(4));
                        taxgst.add((Double)taxarray.get(0));
                    } else {
                        taxtaxable.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxtaxable.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(4));
                        taxgst.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxgst.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(0));
                    }
                    if (rst.getString("gst_type").contentEquals("E")) {
                        gstsumexc += ((Double)taxarray.get(0)).doubleValue();
                    } else {
                        gstsuminc += ((Double)taxarray.get(0)).doubleValue();
                    }
                    if (rst.getString("cess_taxtype").contentEquals("E")) {
                        cesssum += ((Double)taxarray.get(2)).doubleValue();
                    }
                    if (rst.getString("fldcess_taxtype").contentEquals("E")) {
                        fcesssum += ((Double)taxarray.get(1)).doubleValue();
                    }
                    amount += ((Double)taxarray.get(3)).doubleValue();
                    discount = rst.getDouble("discount_amt");
                    ++i;
                }
                String cusname = "";
                String cusno = "";
                String address = "";
                if (rs.getInt("cus_id") != 0) {
                    ResultSet rsp = this.db.SERVER_TableSelection_SELECTION("SELECT customername,phone,address FROM svr_coustomerparent where acid=" + rs.getInt("cus_id"));
                    rsp.next();
                    cusname = rsp.getString("customername");
                    cusno = rsp.getString("phone");
                    address = rsp.getString("address");
                }
                double roundoff = 0.0;
                if (rs.getString("billdisctype").contentEquals("C")) {
                    discount += rs.getDouble("duebill_discount");
                } else if (rs.getString("billdisctype").contentEquals("P")) {
                    discount += amount * rs.getDouble("duebill_discount") / 100.0;
                }
                ResultSet rsp = this.db.SERVER_TableSelection_SELECTION("select roundoffvalue from temp_pos_parent where transactionid=" + transactionid);
                if (rsp.next()) {
                    roundoff = rsp.getDouble("roundoffvalue");
                }
                String str = "";
                str = !rs.getString("tabletokenno").isEmpty() ? "Token No : " + rs.getString("tabletokenno") : "Table No : " + rs.getString("tableno");
                if (!PRINTERIP.contentEquals("")) {
                    this.EPosPrint_DueBill(shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, rs.getString("employeename"), rss2.getString("billchar") + " " + rss3.getInt("id"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, discount, rs.getDouble("deliverychrg"), roundoff, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), footer, shopfssi, gstsumexc, gstsuminc, arabicname, PRINTERIP);
                }
            }
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
            Logger.getLogger(PosDuebillPrintFormat4ArabicThermal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void EPosPrint_DueBill(String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, String billdate, String billtime, String cusname, String cusno, String address, String t_string, String empname, String billno, ArrayList<String> itemname, ArrayList<Double> itemqty, ArrayList<Double> itemprice, int settings_numberfraction, ArrayList<Double> taxname, ArrayList<Double> taxtaxable, ArrayList<Double> taxgst, double fcesssum, double cesssum, double discount, double deliverychrg, double roundoff, String ordermode, int takeawaytype, int deliveryboy, String footer, String shopfssi, double gstexcsum, double gstincsum, ArrayList<String> arabicname, String PRINTERIP) {
        try {
            EscPos escpos = null;
            int settings_duebillpaper = 0;
            TcpIpOutputStream tcp = new TcpIpOutputStream(PRINTERIP, 9100);
            escpos = new EscPos((OutputStream)tcp);
            int PAGE_FULLWIDTH_FONT_A = 0;
            PAGE_FULLWIDTH_FONT_A = settings_duebillpaper == 0 ? 47 : 38;
            EposPrintingInterface eposMethods = new EposPrintingInterface();
            EposTextToImageCretor ettc = new EposTextToImageCretor();
            escpos.initializePrinter();
            if (!shoplogo.isEmpty()) {
                try {
                    Object imageWrapper = new BitImageWrapper();
                    imageWrapper.setJustification(EscPosConst.Justification.Center);
                    BufferedImage img = ImageIO.read(new File(shoplogo));
                    BitonalOrderedDither algorithm = new BitonalOrderedDither();
                    EscPosImage escposImage = new EscPosImage((CoffeeImage)new CoffeeImageImpl(img), (Bitonal)algorithm);
                    escpos.write((ImageWrapperInterface)imageWrapper, escposImage);
                    escpos.feed(1);
                }
                catch (Exception imageWrapper) {
                    // empty catch block
                }
            }
            if (!shopname.isEmpty()) {
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setBold(true).setFontName(Style.FontName.Font_B).setFontSize(Style.FontSize._2, Style.FontSize._2), shopname);
            }
            if (!shopaddr.isEmpty()) {
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(Style.FontName.Font_A_Default).setFontSize(Style.FontSize._1, Style.FontSize._1), shopaddr);
            }
            if (!shopemail.isEmpty()) {
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(Style.FontName.Font_A_Default).setFontSize(Style.FontSize._1, Style.FontSize._1), shopemail);
            }
            if (!shopmob.isEmpty()) {
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(Style.FontName.Font_A_Default).setFontSize(Style.FontSize._1, Style.FontSize._1), shopmob);
            }
            if (!shopgst.isEmpty()) {
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(Style.FontName.Font_A_Default).setFontSize(Style.FontSize._1, Style.FontSize._1), shopgst);
            }
            if (!shopfssi.isEmpty()) {
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(Style.FontName.Font_A_Default).setFontSize(Style.FontSize._1, Style.FontSize._1), shopfssi);
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setBold(true).setFontName(Style.FontName.Font_B).setFontSize(Style.FontSize._2, Style.FontSize._2), "TAX INVOICE");
            ettc.Get(escpos, "\u0641\u0627\u062a\u0648\u0631\u0629 \u0636\u0631\u064a\u0628\u064a\u0629", 35, 0, 36, 150, 25);
            escpos.write(eposMethods.MultiDataSingleLine("Date : " + billdate + " " + billtime, PAGE_FULLWIDTH_FONT_A / 2 + 1, 'R') + eposMethods.MultiDataSingleLine("Inv No : " + billno, PAGE_FULLWIDTH_FONT_A / 2 - 1, 'L'));
            escpos.feed(1);
            escpos.write(eposMethods.MultiDataSingleLine("Staff : " + empname, PAGE_FULLWIDTH_FONT_A / 2 + 5, 'R') + eposMethods.MultiDataSingleLine(t_string, PAGE_FULLWIDTH_FONT_A / 2 - 5, 'L'));
            escpos.feed(1);
            switch (ordermode) {
                case "I": {
                    escpos.writeLF(eposMethods.MultiDataSingleLine("Order Mode : Dine In", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
                case "D": {
                    if (deliveryboy == 0) {
                        escpos.writeLF(eposMethods.MultiDataSingleLine("Order Mode : Delivery", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                        break;
                    }
                    ResultSet srs = this.db.SERVER_TableSelection_SELECTION("select employeename from svr_employeeparent where employeeid=" + deliveryboy);
                    srs.next();
                    escpos.writeLF(eposMethods.MultiDataSingleLine("Order Mode : Delivery(" + srs.getString(1) + ")", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
                case "T": {
                    ResultSet srs = this.db.SERVER_TableSelection_SELECTION("select takeaway_name from svr_takeawaycharges where id=" + takeawaytype);
                    srs.next();
                    escpos.writeLF(eposMethods.MultiDataSingleLine("Order Mode : Takeaway(" + srs.getString("takeaway_name") + ")", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
            }
            if (!cusname.isEmpty()) {
                escpos.write("Customer : " + cusname + " (" + cusno + ")");
                escpos.feed(1);
                if (address != null && !address.isEmpty()) {
                    escpos.writeLF(address);
                }
            }
            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            escpos.feed(1);
            Object sb = null;
            int DESCRIPTION_MAX_LEN = PAGE_FULLWIDTH_FONT_A - 18;
            int QTY_MAX_LEN = 5;
            int ARP_MAX_LEN = 6;
            int TOTAL_MAX_LEN = 7;
            if (settings_duebillpaper == 0) {
                escpos.writeLF(new Style().setBold(true), "Item                           Qty  Rate  Total");
                ettc.Get(escpos, "\u063a\u0631\u0636  \u0643\u0645\u064a \u0645\u0639\u062f\u0644          \u0627\u0644\u0645\u062c\u0645\u0648\u0639", 32, 0, 33, 0, 22);
            } else {
                escpos.writeLF(new Style().setBold(true), "Item                   Qty  Rate  Total");
                ettc.Get(escpos, "\u063a\u0631\u0636  \u0643\u0645\u064a \u0645\u0639\u062f\u0644       \u0627\u0644\u0645\u062c\u0645\u0648\u0639", 32, 0, 33, 0, 22);
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            double normaltotal = 0.0;
            for (int i = 0; i < itemname.size(); ++i) {
                double qnty = itemqty.get(i);
                int qty = (int)qnty;
                String qstring = "";
                qstring = qnty == (double)qty ? String.valueOf(qty) : String.valueOf(qnty);
                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine(itemname.get(i), DESCRIPTION_MAX_LEN, 'R') + eposMethods.MultiDataSingleLine(qstring, QTY_MAX_LEN, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(itemprice.get(i).doubleValue(), settings_numberfraction), ARP_MAX_LEN, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(itemprice.get(i) * itemqty.get(i), settings_numberfraction), TOTAL_MAX_LEN, 'L'));
                escpos.feed(1);
                if (itemname.get(i).length() > DESCRIPTION_MAX_LEN) {
                    escpos.writeLF(new Style().setFontName(Style.FontName.Font_A_Default), itemname.get(i).substring(DESCRIPTION_MAX_LEN - 1));
                }
                if (arabicname.get(i) != null && !arabicname.get(i).isEmpty()) {
                    ettc.Get(escpos, arabicname.get(i), 32, 0, 33, 0, 22);
                }
                normaltotal += itemprice.get(i) * itemqty.get(i);
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine("Sub Total :", PAGE_FULLWIDTH_FONT_A - 10, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(normaltotal, settings_numberfraction), 10, 'L'));
            escpos.feed(1);
            if (gstexcsum + gstincsum > 0.0) {
                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine("VAT :", PAGE_FULLWIDTH_FONT_A - 10, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(gstexcsum + gstincsum, settings_numberfraction), 10, 'L'));
                escpos.feed(1);
            }
            if (cesssum != 0.0) {
                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine("CESS : ", PAGE_FULLWIDTH_FONT_A - 10, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(cesssum, settings_numberfraction), 10, 'L'));
                escpos.feed(1);
            }
            if (fcesssum != 0.0) {
                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine("FCESS : ", PAGE_FULLWIDTH_FONT_A - 10, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(fcesssum, settings_numberfraction), 10, 'L'));
                escpos.feed(1);
            }
            if (deliverychrg > 0.0) {
                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine("Delivery Charge :", PAGE_FULLWIDTH_FONT_A - 10, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(deliverychrg, settings_numberfraction), 10, 'L'));
                escpos.feed(1);
            }
            if (discount > 0.0) {
                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine("Discount :", PAGE_FULLWIDTH_FONT_A - 10, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(discount, settings_numberfraction), 10, 'L'));
                escpos.feed(1);
            }
            if (roundoff != 0.0) {
                escpos.write(new Style().setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine("Round Off :", PAGE_FULLWIDTH_FONT_A - 10, 'L') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(roundoff, settings_numberfraction), 10, 'L'));
                escpos.feed(1);
            }
            int TAX_MAX_LEN = 10;
            int TAXABLE_MAX_LEN = 12;
            int CGST_MAX_LEN = 10;
            int TOTTAX_MAX_LEN = PAGE_FULLWIDTH_FONT_A - 32;
            double nettotal = normaltotal + gstexcsum + cesssum + fcesssum + deliverychrg - discount + roundoff;
            escpos.writeLF(new Style().setBold(true).setFontSize(Style.FontSize._2, Style.FontSize._2).setFontName(Style.FontName.Font_B).setJustification(EscPosConst.Justification.Right).setLineSpacing(2), "NET TOTAL : " + StaticObjects.vimp_utility.Decimalpointlength(nettotal, settings_numberfraction) + " AED");
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            if (taxname.get(0) != 0.0) {
                if (settings_duebillpaper == 0) {
                    escpos.writeLF(new Style().setBold(true), "Amount       Tax      Tax Amt             Total");
                } else {
                    escpos.writeLF(new Style().setBold(true), "Amount       Tax      Tax Amt     Total");
                }
                for (int j = 0; j < taxname.size(); ++j) {
                    escpos.write(new Style().setBold(true).setFontName(Style.FontName.Font_A_Default), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxtaxable.get(j).doubleValue(), settings_numberfraction), TAX_MAX_LEN, 'R') + eposMethods.MultiDataSingleLine("VAT" + taxname.get(j) + "%", TAXABLE_MAX_LEN, 'R') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxgst.get(j).doubleValue(), settings_numberfraction), CGST_MAX_LEN, 'R') + eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxtaxable.get(j) + taxgst.get(j), settings_numberfraction), TOTTAX_MAX_LEN - 1, 'L'));
                    escpos.feed(1);
                }
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            }
            if (!footer.isEmpty()) {
                escpos.writeLF(new Style().setBold(true).setJustification(EscPosConst.Justification.Center), "*** " + footer + " ***");
            }
            escpos.feed(4);
            escpos.cut(EscPos.CutMode.PART);
            escpos.close();
        }
        catch (Exception ex) {
            Logger.getLogger(PosDuebillPrintFormat4ArabicThermal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printType2(int invoiceid, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, int settings_numberfraction, String footer, String shopfssi, String PRINTERIP) {
        try {
            String cusname = "";
            String cusno = "";
            String address = "";
            ResultSet rs = this.db.SERVER_TableSelection_SELECTION("select date(billingtime) as date,time(billingtime) as time,cus_acid,tabletokenno,t.tableno,ordtakerid,ifnull(billchar,'') billchar,billno,settlingprice,deliverychrg,roundoffvalue,parceltype,takeawaytype,deliveryboy,kotno from svr_invoiceparent p inner join svr_tableparent t on p.tableno=tableid where invoiceid=" + invoiceid);
            if (rs.next()) {
                if (rs.getInt("cus_acid") != 0) {
                    ResultSet rsp = this.db.SERVER_TableSelection_SELECTION("SELECT customername,phone,address FROM svr_coustomerparent where acid=" + rs.getInt("cus_id"));
                    rsp.next();
                    cusname = rsp.getString("customername");
                    cusno = rsp.getString("phone");
                    address = rsp.getString("address");
                } else {
                    ResultSet rsp1 = this.db.SERVER_TableSelection_SELECTION("SELECT acid FROM svr_valetcardinvoice_details WHERE inv_rowid=" + invoiceid + " order by id desc limit 1");
                    if (rsp1.next()) {
                        ResultSet rsp = this.db.SERVER_TableSelection_SELECTION("SELECT customername,phone,address FROM svr_coustomerparent where acid=" + rsp1.getInt("acid"));
                        rsp.next();
                        cusname = rsp.getString("customername");
                        cusno = rsp.getString("phone");
                        address = rsp.getString("address");
                    }
                }
                String str = "";
                str = !rs.getString("tabletokenno").isEmpty() ? "Token No : " + rs.getString("tabletokenno") : "Table No : " + rs.getString("tableno");
                String emp = "";
                if (rs.getInt("ordtakerid") != 0) {
                    ResultSet rst = this.db.SERVER_TableSelection_SELECTION("select employeename from svr_employeeparent where employeeid=" + rs.getInt("ordtakerid"));
                    rst.next();
                    emp = rst.getString(1);
                }
                ArrayList<String> itemname = new ArrayList<String>();
                ArrayList<String> arabicname = new ArrayList<String>();
                ArrayList<Double> itemqty = new ArrayList<Double>();
                ArrayList<Double> itemprice = new ArrayList<Double>();
                ArrayList<Double> taxname = new ArrayList<Double>();
                ArrayList<Double> taxtaxable = new ArrayList<Double>();
                ArrayList<Double> taxgst = new ArrayList<Double>();
                double gstsumexc = 0.0;
                double gstsuminc = 0.0;
                double fcesssum = 0.0;
                double cesssum = 0.0;
                double discount = 0.0;
                ResultSet rst = this.db.SERVER_TableSelection_SELECTION("select itemname,arabicname,itemquantity,(itemquantity*itemprice)-(itemquantity*itemdiscount) as total,itemprice,itemdiscount,gsttype,gstper,fldcesstype,fldcessper,b.cess_type,b.cess_per from svr_itemparent a inner join svr_invoicechild b on itemcode=basebarcode where invoiceid=" + invoiceid);
                int i = 0;
                while (rst.next()) {
                    itemname.add(rst.getString("itemname"));
                    arabicname.add(rst.getString("arabicname"));
                    itemqty.add(rst.getDouble("itemquantity"));
                    itemprice.add(rst.getDouble("itemprice"));
                    ArrayList taxarray = this.GST_Calculation(rst.getDouble("total"), rst.getString("gsttype"), rst.getDouble("gstper"), rst.getString("fldcesstype"), rst.getDouble("fldcessper"), rst.getString("cess_type"), rst.getDouble("cess_per"));
                    if (!taxname.contains(rst.getDouble("gstper"))) {
                        taxname.add(rst.getDouble("gstper"));
                        taxtaxable.add((Double)taxarray.get(4));
                        taxgst.add((Double)taxarray.get(0));
                    } else {
                        taxtaxable.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxtaxable.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(4));
                        taxgst.set(taxname.indexOf(rst.getDouble("gstper")), taxgst.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(0));
                    }
                    if (rst.getString("gsttype").contentEquals("E")) {
                        gstsumexc += ((Double)taxarray.get(0)).doubleValue();
                    } else {
                        gstsuminc += ((Double)taxarray.get(0)).doubleValue();
                    }
                    if (rst.getString("cess_type").contentEquals("E")) {
                        cesssum += ((Double)taxarray.get(2)).doubleValue();
                    }
                    if (rst.getString("fldcesstype").contentEquals("E")) {
                        fcesssum += ((Double)taxarray.get(1)).doubleValue();
                    }
                    discount += rst.getDouble("itemdiscount");
                    ++i;
                }
                if (!PRINTERIP.contentEquals("")) {
                    this.EPosPrint_DueBill(shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, emp, rs.getString("billchar") + " " + rs.getInt("billno"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, rs.getDouble("settlingprice") - discount, rs.getDouble("deliverychrg"), rs.getDouble("roundoffvalue"), rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), footer, shopfssi, gstsumexc, gstsuminc, arabicname, PRINTERIP);
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PosDuebillPrintFormat4ArabicThermal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ArrayList GST_Calculation(double itemtotal, String gsttype, double gstper, String fldcesstype, double fldcessper, String cesstype, double cessper) {
        if (gsttype.isEmpty()) {
            gsttype = "I";
        }
        if (fldcesstype.isEmpty()) {
            fldcesstype = "I";
        }
        if (cesstype.isEmpty()) {
            cesstype = "I";
        }
        ArrayList<Double> tax_array = new ArrayList<Double>();
        if (gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double gst = itemtotal * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = itemtotal * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = itemtotal * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + fldcess + cess);
            tax_array.add(itemtotal);
        } else if (gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + fldcess);
            tax_array.add(taxablevalue);
        } else if (gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + fldcessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + cess);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + fldcess + cess);
            tax_array.add(taxablevalue);
        } else if (gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + fldcessper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + fldcess);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + fldcessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + cess);
            tax_array.add(taxablevalue);
        } else if (!(gsttype.contentEquals("E") || fldcesstype.contentEquals("E") || cesstype.contentEquals("E"))) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + fldcessper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal);
            tax_array.add(taxablevalue);
        }
        return tax_array;
    }
}

