/*
 * Decompiled with CFR 0.152.
 */
package Package_Printing;

import Package_Printing.EposPrintingInterface;
import Utility.DbAction;
import Utility.StaticObjects;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.image.BitImageWrapper;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.BitonalOrderedDither;
import com.github.anastaciocintra.escpos.image.CoffeeImage;
import com.github.anastaciocintra.escpos.image.CoffeeImageImpl;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import com.github.anastaciocintra.output.PrinterOutputStream;
import com.github.anastaciocintra.output.TcpIpOutputStream;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.print.PrintService;

public class PosDuebillPrintFormat1 {
    private DbAction db = new DbAction();
    private Style.FontName font;
    private Style.FontSize fontwidth;
    private Style.FontSize fontheight;
    String shopname1;
    String shopaddress1;
    String shopmobile1;
    String shopemail1;
    String shoptinno1;
    String shopimage1;
    String shopfssai1;

    public void printduebill(int transactionid, int settings_numberfraction, int type, String printerip, String fileabsalutepath) {
        boolean settings_duebill1paper = false;
        boolean settings_duebill1copies = false;
        int settings_duebill2paper = 0;
        int settings_duebill2copies = 0;
        int settings_duebill3paper = 0;
        int settings_duebill3copies = 0;
        String settings_duebill1printer = "Off";
        String settings_duebill1portno = "0";
        String settings_duebill2printer = "Off";
        String settings_duebill2portno = "0";
        String settings_duebill3printer = "Off";
        String settings_duebill3portno = "0";
        try {
            DbAction db = new DbAction();
            ResultSet rs = db.CLIENT_TableSelection_SELECTION("SELECT shopname,shopmobile,shopaddress,shopemail,tinno,icon_path,ifnull(fssi,'') fssi FROM svr_shopdetailsparent where sts='A' order by shopid DESC limit 1");
            if (rs.next()) {
                this.shopname1 = rs.getString("shopname");
                this.shopaddress1 = rs.getString("shopaddress");
                this.shopmobile1 = rs.getString("shopmobile");
                this.shopemail1 = rs.getString("shopemail");
                this.shoptinno1 = rs.getString("tinno");
                this.shopimage1 = rs.getString("icon_path");
                this.shopfssai1 = rs.getString("fssi");
            }
            String shoplogo = "";
            String shopname = "";
            String addr = "";
            String contact = "";
            String email = "";
            String shopgstno = "";
            String shopfssi = "";
            ResultSet rsh = db.CLIENT_TableSelection_SELECTION("select data from svr_settings where name='pos_printheader'");
            if (rsh.next() && rsh.getString("data") != null) {
                String[] list;
                String[] stringArray = list = rsh.getString("data").split("#");
                int n = stringArray.length;
                block20: for (int i = 0; i < n; ++i) {
                    String show;
                    switch (show = stringArray[i]) {
                        case "logo": {
                            File imageFile = new File(fileabsalutepath + "src/resource/images/shop/" + this.shopimage1);
                            if (imageFile.exists()) {
                                shoplogo = imageFile.toString();
                                continue block20;
                            }
                            shoplogo = fileabsalutepath + "src/resource/images/defaulticon/defaultshop.jpg";
                            continue block20;
                        }
                        case "name": {
                            shopname = this.shopname1;
                            continue block20;
                        }
                        case "address": {
                            addr = this.shopaddress1;
                            continue block20;
                        }
                        case "contact": {
                            contact = this.shopmobile1;
                            continue block20;
                        }
                        case "email": {
                            email = this.shopemail1;
                            continue block20;
                        }
                        case "gst": {
                            shopgstno = this.shoptinno1;
                            continue block20;
                        }
                        case "fssi": {
                            shopfssi = this.shopfssai1;
                            continue block20;
                        }
                    }
                }
            }
            String footer = "";
            ResultSet rsf = db.CLIENT_TableSelection_SELECTION("select ifnull(data,'') as data from svr_settings where name='pos_printfooter'");
            if (rsf.next()) {
                footer = rsf.getString("data");
            }
            this.printType1(transactionid, printerip, 1, "9100", 0, shoplogo, shopname, addr, contact, email, shopgstno, settings_numberfraction, footer, settings_duebill2printer, settings_duebill2copies, settings_duebill2portno, settings_duebill2paper, settings_duebill3printer, settings_duebill3copies, settings_duebill3portno, settings_duebill3paper, shopfssi);
        }
        catch (SQLException ex) {
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printType1(int transactionid, String settings_duebill1printer, int settings_duebill1copies, String settings_duebill1portno, int settings_duebill1paper, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, int settings_numberfraction, String footer, String settings_duebill2printer, int settings_duebill2copies, String settings_duebill2portno, int settings_duebill2paper, String settings_duebill3printer, int settings_duebill3copies, String settings_duebill3portno, int settings_duebill3paper, String shopfssi) {
        System.out.print("print1");
        try {
            ResultSet rs = this.db.SERVER_TableSelection_SELECTION("select ifnull(b.tableno,'') as tableno,ifnull(employeename,'') as employeename,a.sectionid as sectionid,date(order_time) as date,time(order_time) as time,billdisctype,deliverychrg,cus_id,parceltype,takeawaytype,deliveryboy,tabletokenno,duebill_discount,billdisctype from ord_invoiceheader a left join svr_employeeparent on staffid=employeeid left join svr_tableparent b on a.tableno=b.tableid where transactionid=" + transactionid);
            if (rs.next()) {
                int i;
                ResultSet rss1 = this.db.SERVER_TableSelection_SELECTION("select gst from svr_sectionparent where sectionid=" + rs.getInt("sectionid"));
                rss1.next();
                ResultSet rss2 = this.db.SERVER_TableSelection_SELECTION("select billchar,tbname FROM act_taxparent where taxvalue=" + rss1.getDouble("gst"));
                rss2.next();
                ResultSet rss3 = this.db.SERVER_TableSelection_SELECTION("select id from " + rss2.getString("tbname") + " where kotno=" + transactionid);
                rss3.next();
                ArrayList<String> itemname = new ArrayList<String>();
                ArrayList<Double> itemqty = new ArrayList<Double>();
                ArrayList<Double> itemprice = new ArrayList<Double>();
                ArrayList<Double> taxname = new ArrayList<Double>();
                ArrayList<Double> taxtaxable = new ArrayList<Double>();
                ArrayList<Double> taxgst = new ArrayList<Double>();
                double fcesssum = 0.0;
                double cesssum = 0.0;
                double amount = 0.0;
                ResultSet rst = this.db.SERVER_TableSelection_SELECTION("select itemname,b.quantity as qty,(b.quantity*unitprice)-(b.quantity*discount_amt) as total,unitprice,discount_amt,gst_type,gstper,fldcess_taxtype,fldcess_per,cess_taxtype,cess_taxper from svr_itemparent a inner join ord_invoicechild b on b.barcode=a.basebarcode where transactionid=" + transactionid);
                int i2 = 0;
                while (rst.next()) {
                    itemname.add(rst.getString("itemname"));
                    itemqty.add(rst.getDouble("qty"));
                    itemprice.add(rst.getDouble("unitprice"));
                    ArrayList taxarray = this.GST_Calculation(rst.getDouble("total"), rst.getString("gst_type"), rst.getDouble("gstper"), rst.getString("fldcess_taxtype"), rst.getDouble("fldcess_per"), rst.getString("cess_taxtype"), rst.getDouble("cess_taxper"));
                    if (!taxname.contains(rst.getDouble("gstper"))) {
                        taxname.add(rst.getDouble("gstper"));
                        taxtaxable.add((Double)taxarray.get(4));
                        taxgst.add((Double)taxarray.get(0));
                    } else {
                        taxtaxable.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxtaxable.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(4));
                        taxgst.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxgst.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(0));
                    }
                    if (rst.getString("cess_taxtype").contentEquals("E")) {
                        cesssum += ((Double)taxarray.get(2)).doubleValue();
                    }
                    if (rst.getString("fldcess_taxtype").contentEquals("E")) {
                        fcesssum += ((Double)taxarray.get(1)).doubleValue();
                    }
                    amount += ((Double)taxarray.get(3)).doubleValue();
                    ++i2;
                }
                double walletpoint = 0.0;
                String cusname = "";
                String cusno = "";
                String address = "";
                if (rs.getInt("cus_id") != 0) {
                    ResultSet rsp = this.db.SERVER_TableSelection_SELECTION("SELECT customername,phone as phoneno,address,ifnull((SELECT SUM(valet_point) FROM svr_valetcardinvoice_details v WHERE v.acid=" + rs.getInt("cus_id") + "),0) as vpoint FROM svr_coustomerparent c where c.acid=" + rs.getInt("cus_id"));
                    rsp.next();
                    cusname = rsp.getString("customername");
                    cusno = rsp.getString("phoneno");
                    address = rsp.getString("address");
                    walletpoint = rsp.getDouble("vpoint");
                }
                double discount = 0.0;
                double roundoff = 0.0;
                if (rs.getString("billdisctype").contentEquals("C")) {
                    discount = rs.getDouble("duebill_discount");
                } else if (rs.getString("billdisctype").contentEquals("P")) {
                    discount = amount * rs.getDouble("duebill_discount") / 100.0;
                }
                ResultSet rsp = this.db.SERVER_TableSelection_SELECTION("select roundoffvalue from temp_pos_parent where transactionid=" + transactionid);
                if (rsp.next()) {
                    roundoff = rsp.getDouble("roundoffvalue");
                }
                String str = "";
                str = !rs.getString("tabletokenno").isEmpty() ? "Token No : " + rs.getString("tabletokenno") : "Table No : " + rs.getString("tableno");
                if (!settings_duebill1printer.trim().isEmpty() && !settings_duebill1printer.trim().contentEquals("Off")) {
                    for (i = 0; i < settings_duebill1copies; ++i) {
                        this.EPosPrint_DueBill(settings_duebill1portno, settings_duebill1printer.trim(), settings_duebill1paper, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, rs.getString("employeename"), rss2.getString("billchar") + " " + rss3.getInt("id"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, discount, rs.getDouble("deliverychrg"), roundoff, walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), transactionid, footer, shopfssi);
                    }
                }
                if (!settings_duebill2printer.trim().isEmpty() && !settings_duebill2printer.trim().contentEquals("Off")) {
                    for (i = 0; i < settings_duebill2copies; ++i) {
                        this.EPosPrint_DueBill(settings_duebill2portno, settings_duebill2printer.trim(), settings_duebill2paper, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, rs.getString("employeename"), rss2.getString("billchar") + " " + rss3.getInt("id"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, discount, rs.getDouble("deliverychrg"), roundoff, walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), transactionid, footer, shopfssi);
                    }
                }
                if (!settings_duebill3printer.trim().isEmpty() && !settings_duebill3printer.trim().contentEquals("Off")) {
                    for (i = 0; i < settings_duebill3copies; ++i) {
                        this.EPosPrint_DueBill(settings_duebill3portno, settings_duebill3printer.trim(), settings_duebill3paper, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, rs.getString("employeename"), rss2.getString("billchar") + " " + rss3.getInt("id"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, discount, rs.getDouble("deliverychrg"), roundoff, walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), transactionid, footer, shopfssi);
                    }
                }
            } else {
                rs = this.db.SERVER_TableSelection_SELECTION("select invoiceid from svr_invoiceparent where kotno=" + transactionid + " order by invoiceid desc limit 1");
                if (rs.next()) {
                    transactionid = rs.getInt(1);
                }
                this.printType2(transactionid, settings_duebill1printer, settings_duebill1copies, settings_duebill1portno, settings_duebill1paper, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, settings_numberfraction, footer, settings_duebill2printer, settings_duebill2copies, settings_duebill2portno, settings_duebill2paper, settings_duebill3printer, settings_duebill3copies, settings_duebill3portno, settings_duebill3paper, shopfssi);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void EPosPrint_DueBill(String settings_duebillportno, String settings_duebillprinter, int settings_duebillpaper, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, String billdate, String billtime, String cusname, String cusno, String address, String t_string, String empname, String billno, ArrayList<String> itemname, ArrayList<Double> itemqty, ArrayList<Double> itemprice, int settings_numberfraction, ArrayList<Double> taxname, ArrayList<Double> taxtaxable, ArrayList<Double> taxgst, double fcesssum, double cesssum, double discount, double deliverychrg, double roundoff, double walletpoint, String ordermode, int takeawaytype, int deliveryboy, int kotno, String footer, String shopfssi) {
        try {
            EscPos escpos = null;
            if (settings_duebillportno.contentEquals("0") || settings_duebillportno.isEmpty()) {
                PrintService printService = PrinterOutputStream.getPrintServiceByName((String)settings_duebillprinter);
                PrinterOutputStream printerOutputStream = new PrinterOutputStream(printService);
                escpos = new EscPos((OutputStream)printerOutputStream);
            } else {
                TcpIpOutputStream tcp = new TcpIpOutputStream(settings_duebillprinter, Integer.parseInt(settings_duebillportno));
                escpos = new EscPos((OutputStream)tcp);
            }
            int PAGE_FULLWIDTH_FONT_A = 0;
            PAGE_FULLWIDTH_FONT_A = settings_duebillpaper == 0 ? 49 : 41;
            EposPrintingInterface eposMethods = new EposPrintingInterface();
            escpos.initializePrinter();
            if (!shoplogo.isEmpty()) {
                Object imageWrapper = new BitImageWrapper();
                imageWrapper.setJustification(EscPosConst.Justification.Center);
                BufferedImage img = ImageIO.read(new File(shoplogo));
                BitonalOrderedDither algorithm = new BitonalOrderedDither();
                EscPosImage escposImage = new EscPosImage((CoffeeImage)new CoffeeImageImpl(img), (Bitonal)algorithm);
                escpos.write((ImageWrapperInterface)imageWrapper, escposImage);
                escpos.feed(1);
            }
            if (!shopname.isEmpty()) {
                this.getFontProperties(1);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopname);
            }
            if (!shopaddr.isEmpty()) {
                this.getFontProperties(2);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopaddr);
            }
            if (!shopemail.isEmpty()) {
                this.getFontProperties(3);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopemail);
            }
            if (!shopmob.isEmpty()) {
                this.getFontProperties(4);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Ph : " + shopmob);
            }
            if (!shopgst.isEmpty()) {
                this.getFontProperties(5);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopgst);
            }
            if (!shopfssi.isEmpty()) {
                this.getFontProperties(6);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), shopfssi);
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DoubleDashedLine(settings_duebillpaper));
            this.getFontProperties(7);
            escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Date : " + billdate + " " + billtime, PAGE_FULLWIDTH_FONT_A / 2 + 1, 'R'));
            this.getFontProperties(8);
            escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Inv No : " + billno, PAGE_FULLWIDTH_FONT_A / 2 - 1, 'L'));
            escpos.feed(1);
            this.getFontProperties(9);
            escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Staff : " + empname, PAGE_FULLWIDTH_FONT_A / 2 + 5, 'R'));
            this.getFontProperties(25);
            escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(t_string, PAGE_FULLWIDTH_FONT_A / 2 - 5, 'L'));
            escpos.feed(1);
            switch (ordermode) {
                case "I": {
                    this.getFontProperties(10);
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Dine In", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
                case "D": {
                    if (deliveryboy == 0) {
                        this.getFontProperties(10);
                        escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Delivery", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                        break;
                    }
                    this.getFontProperties(10);
                    ResultSet srs = this.db.SERVER_TableSelection_SELECTION("select employeename from svr_employeeparent where employeeid=" + deliveryboy);
                    srs.next();
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Delivery(" + srs.getString(1) + ")", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
                case "T": {
                    ResultSet srs = this.db.SERVER_TableSelection_SELECTION("select takeaway_name from svr_takeawaycharges where id=" + takeawaytype);
                    this.getFontProperties(10);
                    srs.next();
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine("Order Mode : Takeaway(" + srs.getString("takeaway_name") + ")", PAGE_FULLWIDTH_FONT_A / 2 + 10, 'R'));
                    break;
                }
            }
            if (!cusname.isEmpty()) {
                this.getFontProperties(11);
                escpos.write("Customer : " + cusname + " (" + cusno + ")");
                escpos.feed(1);
                if (address != null && !address.isEmpty()) {
                    escpos.writeLF(address);
                }
            }
            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            escpos.feed(1);
            int SI_MAX_LEN = 2;
            int DESCRIPTION_MAX_LEN = PAGE_FULLWIDTH_FONT_A - 24;
            int QTY_MAX_LEN = 5;
            int ARP_MAX_LEN = 8;
            int TOTAL_MAX_LEN = 8;
            if (settings_duebillpaper == 0) {
                this.getFontProperties(29);
                escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), "SL Item                      Qty    Rate   Total");
            } else {
                this.getFontProperties(29);
                escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), "SL Item          Qty     Rate     Total");
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            int i = 0;
            for (i = 0; i < itemname.size(); ++i) {
                this.getFontProperties(12);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(String.valueOf(i + 1), SI_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(" " + itemname.get(i), DESCRIPTION_MAX_LEN, 'R'));
                double qnty = itemqty.get(i);
                int qty = (int)qnty;
                String qstring = "";
                qstring = qnty == (double)qty ? String.valueOf(qty) : String.valueOf(qnty);
                this.getFontProperties(27);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(qstring, QTY_MAX_LEN, 'L'));
                escpos.write(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(itemprice.get(i).doubleValue(), settings_numberfraction), ARP_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(itemprice.get(i) * itemqty.get(i), settings_numberfraction), TOTAL_MAX_LEN, 'L'));
                escpos.feed(1);
                if (itemname.get(i).length() <= DESCRIPTION_MAX_LEN) continue;
                this.getFontProperties(12);
                escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true).setFontName(this.font).setBold(true), "   " + itemname.get(i).substring(DESCRIPTION_MAX_LEN - 1));
            }
            escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            double taxabletot = 0.0;
            double cgsttot = 0.0;
            double taxamttot = 0.0;
            int TAX_MAX_LEN = 12;
            int TAXABLE_MAX_LEN = 10;
            int CGST_MAX_LEN = 8;
            int TOTTAX_MAX_LEN = 9;
            if (taxname.size() != 1 || taxname.get(0) != 0.0) {
                if (settings_duebillpaper == 0) {
                    this.getFontProperties(30);
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), "Tax      Taxable Value    CGST   SGST Tax Amount");
                } else {
                    this.getFontProperties(30);
                    escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true), "Tax     Taxable Value    CGST SGST Tax Amount");
                }
            }
            for (int j = 0; j < taxname.size(); ++j) {
                if (taxname.size() != 1 || taxname.get(0) != 0.0) {
                    this.getFontProperties(16);
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("GST@" + taxname.get(j), TAX_MAX_LEN, 'R'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxtaxable.get(j).doubleValue(), settings_numberfraction), TAXABLE_MAX_LEN, 'L'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxgst.get(j) / 2.0, settings_numberfraction), CGST_MAX_LEN, 'L'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxgst.get(j) / 2.0, settings_numberfraction), CGST_MAX_LEN - 1, 'L'));
                    escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxtaxable.get(j) + taxgst.get(j), settings_numberfraction), TOTTAX_MAX_LEN + 2, 'L'));
                    escpos.feed(1);
                }
                taxabletot += taxtaxable.get(j).doubleValue();
                cgsttot += taxgst.get(j) / 2.0;
                taxamttot += taxtaxable.get(j) + taxgst.get(j);
            }
            if (taxname.size() != 1 && taxname.get(0) != 0.0) {
                this.getFontProperties(13);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("Total", TAX_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxabletot, settings_numberfraction), TAXABLE_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(cgsttot, settings_numberfraction), CGST_MAX_LEN, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(cgsttot, settings_numberfraction), CGST_MAX_LEN - 1, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(taxamttot, settings_numberfraction), TOTTAX_MAX_LEN + 2, 'L'));
                escpos.feed(1);
            }
            if (cesssum != 0.0) {
                this.getFontProperties(14);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("CESS : ", PAGE_FULLWIDTH_FONT_A - TOTAL_MAX_LEN + 3, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(cesssum, settings_numberfraction), TOTAL_MAX_LEN - 4, 'L'));
                escpos.feed(1);
            }
            if (fcesssum != 0.0) {
                this.getFontProperties(15);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine("FCESS : ", PAGE_FULLWIDTH_FONT_A - TOTAL_MAX_LEN + 3, 'L'));
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), eposMethods.MultiDataSingleLine(StaticObjects.vimp_utility.Decimalpointlength(fcesssum, settings_numberfraction), TOTAL_MAX_LEN - 4, 'L'));
                escpos.feed(1);
            }
            this.getFontProperties(17);
            escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Total Items : " + i);
            if (discount > 0.0) {
                this.getFontProperties(18);
                escpos.write(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Bill Discount : " + StaticObjects.vimp_utility.Decimalpointlength(discount, settings_numberfraction));
                escpos.feed(1);
            }
            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            escpos.feed(1);
            double nettotal = taxamttot + fcesssum + cesssum + deliverychrg - discount + roundoff;
            if (deliverychrg > 0.0) {
                this.getFontProperties(19);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Right).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Delivery Charge : " + deliverychrg);
            }
            this.getFontProperties(20);
            escpos.writeLF(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setJustification(EscPosConst.Justification.Right).setLineSpacing(3), "NET TOTAL : " + StaticObjects.vimp_utility.Decimalpointlength(nettotal, settings_numberfraction));
            this.getFontProperties(28);
            escpos.writeLF(new Style().setBold(true).setFontSize(this.fontwidth, this.fontheight).setFontName(this.font).setJustification(EscPosConst.Justification.Left_Default), StaticObjects.vimp_utility.NumberToword((int)Math.round(nettotal), 2));
            escpos.write(new Style().setJustification(EscPosConst.Justification.Center), eposMethods.DashedLine(settings_duebillpaper));
            escpos.feed(1);
            if (walletpoint > 0.0) {
                this.getFontProperties(21);
                escpos.writeLF(new Style().setJustification(EscPosConst.Justification.Center).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight), "Loyalty Point : " + walletpoint + " coin     Point Redeemed : 0.00");
                escpos.feed(1);
            }
            this.getFontProperties(22);
            escpos.writeLF(new Style().setBold(true).setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setJustification(EscPosConst.Justification.Left_Default), "KOT NO : " + kotno);
            escpos.feed(1);
            if (!footer.isEmpty()) {
                this.getFontProperties(23);
            }
            escpos.writeLF(new Style().setFontName(this.font).setFontSize(this.fontwidth, this.fontheight).setBold(true).setJustification(EscPosConst.Justification.Center), "*** " + footer + " ***");
            escpos.feed(4);
            escpos.cut(EscPos.CutMode.PART);
            escpos.close();
        }
        catch (Exception ex) {
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printType2(int invoiceid, String settings_duebill1printer, int settings_duebill1copies, String settings_duebill1portno, int settings_duebill1paper, String shoplogo, String shopname, String shopaddr, String shopmob, String shopemail, String shopgst, int settings_numberfraction, String footer, String settings_duebill2printer, int settings_duebill2copies, String settings_duebill2portno, int settings_duebill2paper, String settings_duebill3printer, int settings_duebill3copies, String settings_duebill3portno, int settings_duebill3paper, String shopfssi) {
        try {
            String cusname = "";
            String cusno = "";
            String address = "";
            double walletpoint = 0.0;
            ResultSet rs = this.db.SERVER_TableSelection_SELECTION("select date(billingtime) as date,time(billingtime) as time,cus_acid,tabletokenno,t.tableno,ordtakerid,billchar,billno,settlingprice,deliverychrg,roundoffvalue,parceltype,takeawaytype,deliveryboy,kotno from svr_invoiceparent p inner join svr_tableparent t on p.tableno=tableid where invoiceid=" + invoiceid);
            if (rs.next()) {
                ResultSet rsp;
                if (rs.getInt("cus_acid") != 0) {
                    rsp = this.db.SERVER_TableSelection_SELECTION("SELECT customername,phone as phoneno,address,ifnull((SELECT SUM(valet_point) FROM svr_valetcardinvoice_details v WHERE v.acid=" + rs.getInt("cus_acid") + "),0) as vpoint FROM svr_coustomerparent c where c.acid=" + rs.getInt("cus_acid"));
                    rsp.next();
                    cusname = rsp.getString("customername");
                    cusno = rsp.getString("phoneno");
                    address = rsp.getString("address");
                    walletpoint = rsp.getDouble("vpoint");
                } else {
                    rsp = this.db.SERVER_TableSelection_SELECTION("SELECT acid FROM svr_valetcardinvoice_details WHERE inv_rowid=" + invoiceid + " order by id desc limit 1");
                    if (rsp.next()) {
                        rsp = this.db.SERVER_TableSelection_SELECTION("SELECT customername,phone as phoneno,address,ifnull((SELECT SUM(valet_point) FROM svr_valetcardinvoice_details v WHERE v.acid=" + rsp.getInt("acid") + "),0) as vpoint FROM svr_coustomerparent c where c.acid=" + rsp.getInt("acid"));
                        rsp.next();
                        cusname = rsp.getString("customername");
                        cusno = rsp.getString("phoneno");
                        address = rsp.getString("address");
                        walletpoint = rsp.getDouble("vpoint");
                    }
                }
                String str = "";
                str = !rs.getString("tabletokenno").isEmpty() ? "Token No : " + rs.getString("tabletokenno") : "Table No : " + rs.getString("tableno");
                String emp = "";
                if (rs.getInt("ordtakerid") != 0) {
                    ResultSet rst = this.db.SERVER_TableSelection_SELECTION("select employeename from svr_employeeparent where employeeid=" + rs.getInt("ordtakerid"));
                    rst.next();
                    emp = rst.getString(1);
                }
                ArrayList<String> itemname = new ArrayList<String>();
                ArrayList<Double> itemqty = new ArrayList<Double>();
                ArrayList<Double> itemprice = new ArrayList<Double>();
                ArrayList<Double> taxname = new ArrayList<Double>();
                ArrayList<Double> taxtaxable = new ArrayList<Double>();
                ArrayList<Double> taxgst = new ArrayList<Double>();
                double fcesssum = 0.0;
                double cesssum = 0.0;
                double discount = 0.0;
                ResultSet rst = this.db.SERVER_TableSelection_SELECTION("select itemname,itemquantity,(itemquantity*itemprice)-(itemquantity*itemdiscount) as total,itemprice,itemdiscount,gsttype,gstper,fldcesstype,fldcessper,b.cess_type,b.cess_per from svr_itemparent a inner join svr_invoicechild b on itemcode=basebarcode where invoiceid=" + invoiceid);
                int i = 0;
                while (rst.next()) {
                    itemname.add(rst.getString("itemname"));
                    itemqty.add(rst.getDouble("itemquantity"));
                    itemprice.add(rst.getDouble("itemprice"));
                    ArrayList taxarray = this.GST_Calculation(rst.getDouble("total"), rst.getString("gsttype"), rst.getDouble("gstper"), rst.getString("fldcesstype"), rst.getDouble("fldcessper"), rst.getString("cess_type"), rst.getDouble("cess_per"));
                    if (!taxname.contains(rst.getDouble("gstper"))) {
                        taxname.add(rst.getDouble("gstper"));
                        taxtaxable.add((Double)taxarray.get(4));
                        taxgst.add((Double)taxarray.get(0));
                    } else {
                        taxtaxable.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxtaxable.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(4));
                        taxgst.set(taxname.indexOf(rst.getDouble("gstper")), (Double)taxgst.get(taxname.indexOf(rst.getDouble("gstper"))) + (Double)taxarray.get(0));
                    }
                    if (rst.getString("cess_type").contentEquals("E")) {
                        cesssum += ((Double)taxarray.get(2)).doubleValue();
                    }
                    if (rst.getString("fldcesstype").contentEquals("E")) {
                        fcesssum += ((Double)taxarray.get(1)).doubleValue();
                    }
                    discount += rst.getDouble("itemdiscount");
                    ++i;
                }
                if (!settings_duebill1printer.trim().isEmpty() && !settings_duebill1printer.trim().contentEquals("Off")) {
                    for (i = 0; i < settings_duebill1copies; ++i) {
                        this.EPosPrint_DueBill(settings_duebill1portno, settings_duebill1printer.trim(), settings_duebill1paper, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, emp, rs.getString("billchar") + " " + rs.getInt("billno"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, rs.getDouble("settlingprice") - discount, rs.getDouble("deliverychrg"), rs.getDouble("roundoffvalue"), walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), rs.getInt("kotno"), footer, shopfssi);
                    }
                }
                if (!settings_duebill2printer.trim().isEmpty() && !settings_duebill2printer.trim().contentEquals("Off")) {
                    for (i = 0; i < settings_duebill2copies; ++i) {
                        this.EPosPrint_DueBill(settings_duebill2portno, settings_duebill2printer.trim(), settings_duebill2paper, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, emp, rs.getString("billchar") + " " + rs.getInt("billno"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, rs.getDouble("settlingprice") - discount, rs.getDouble("deliverychrg"), rs.getDouble("roundoffvalue"), walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), rs.getInt("kotno"), footer, shopfssi);
                    }
                }
                if (!settings_duebill3printer.trim().isEmpty() && !settings_duebill3printer.trim().contentEquals("Off")) {
                    for (i = 0; i < settings_duebill3copies; ++i) {
                        this.EPosPrint_DueBill(settings_duebill3portno, settings_duebill3printer.trim(), settings_duebill3paper, shoplogo, shopname, shopaddr, shopmob, shopemail, shopgst, StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("date"), 2, 0), StaticObjects.vimp_utility.DateAndTimeFormatChange(rs.getString("time"), 0, 3), cusname, cusno, address, str, emp, rs.getString("billchar") + " " + rs.getInt("billno"), itemname, itemqty, itemprice, settings_numberfraction, taxname, taxtaxable, taxgst, fcesssum, cesssum, rs.getDouble("settlingprice") - discount, rs.getDouble("deliverychrg"), rs.getDouble("roundoffvalue"), walletpoint, rs.getString("parceltype"), rs.getInt("takeawaytype"), rs.getInt("deliveryboy"), rs.getInt("kotno"), footer, shopfssi);
                    }
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PosDuebillPrintFormat1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ArrayList GST_Calculation(double itemtotal, String gsttype, double gstper, String fldcesstype, double fldcessper, String cesstype, double cessper) {
        if (gsttype.isEmpty()) {
            gsttype = "I";
        }
        if (fldcesstype.isEmpty()) {
            fldcesstype = "I";
        }
        if (cesstype.isEmpty()) {
            cesstype = "I";
        }
        ArrayList<Double> tax_array = new ArrayList<Double>();
        if (gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double gst = itemtotal * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = itemtotal * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = itemtotal * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + fldcess + cess);
            tax_array.add(itemtotal);
        } else if (gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + fldcess);
            tax_array.add(taxablevalue);
        } else if (gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + fldcessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst + cess);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + fldcess + cess);
            tax_array.add(taxablevalue);
        } else if (gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + fldcessper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + gst);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && fldcesstype.contentEquals("E") && !cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + fldcess);
            tax_array.add(taxablevalue);
        } else if (!gsttype.contentEquals("E") && !fldcesstype.contentEquals("E") && cesstype.contentEquals("E")) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + fldcessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal + cess);
            tax_array.add(taxablevalue);
        } else if (!(gsttype.contentEquals("E") || fldcesstype.contentEquals("E") || cesstype.contentEquals("E"))) {
            double taxablevalue = itemtotal * 100.0 / (100.0 + gstper + fldcessper + cessper);
            double gst = taxablevalue * gstper / 100.0;
            tax_array.add(gst);
            double fldcess = taxablevalue * fldcessper / 100.0;
            tax_array.add(fldcess);
            double cess = taxablevalue * cessper / 100.0;
            tax_array.add(cess);
            tax_array.add(itemtotal);
            tax_array.add(taxablevalue);
        }
        return tax_array;
    }

    public void getFontProperties(int i) {
        this.font = Style.FontName.Font_A_Default;
        this.fontwidth = Style.FontSize._1;
        this.fontheight = Style.FontSize._1;
        try {
            ResultSet rsst = this.db.CLIENT_TableSelection_SELECTION("select sts,data from svr_settings where name='duebill_s" + i + "font'");
            if (rsst.next()) {
                System.out.print("font pr");
                switch (rsst.getString("sts")) {
                    case "A": {
                        this.font = Style.FontName.Font_A_Default;
                        break;
                    }
                    case "B": {
                        this.font = Style.FontName.Font_B;
                        break;
                    }
                    default: {
                        this.font = Style.FontName.Font_C;
                    }
                }
                String[] list = rsst.getString("data").split("#");
                try {
                    switch (list[0]) {
                        case "1": {
                            this.fontwidth = Style.FontSize._1;
                            break;
                        }
                        case "2": {
                            this.fontwidth = Style.FontSize._2;
                            break;
                        }
                        case "3": {
                            this.fontwidth = Style.FontSize._3;
                            break;
                        }
                        case "4": {
                            this.fontwidth = Style.FontSize._4;
                            break;
                        }
                        case "5": {
                            this.fontwidth = Style.FontSize._5;
                            break;
                        }
                        case "6": {
                            this.fontwidth = Style.FontSize._6;
                            break;
                        }
                        case "7": {
                            this.fontwidth = Style.FontSize._7;
                            break;
                        }
                        default: {
                            this.fontwidth = Style.FontSize._8;
                        }
                    }
                    switch (list[1]) {
                        case "1": {
                            this.fontheight = Style.FontSize._1;
                            break;
                        }
                        case "2": {
                            this.fontheight = Style.FontSize._2;
                            break;
                        }
                        case "3": {
                            this.fontheight = Style.FontSize._3;
                            break;
                        }
                        case "4": {
                            this.fontheight = Style.FontSize._4;
                            break;
                        }
                        case "5": {
                            this.fontheight = Style.FontSize._5;
                            break;
                        }
                        case "6": {
                            this.fontheight = Style.FontSize._6;
                            break;
                        }
                        case "7": {
                            this.fontwidth = Style.FontSize._7;
                            break;
                        }
                        default: {
                            this.fontheight = Style.FontSize._8;
                            break;
                        }
                    }
                }
                catch (Exception e1x) {
                    System.out.println(e1x);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

