/*
 * Decompiled with CFR 0.152.
 */
package Package_Printing;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.BitonalThreshold;
import com.github.anastaciocintra.escpos.image.CoffeeImage;
import com.github.anastaciocintra.escpos.image.CoffeeImageImpl;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import com.github.anastaciocintra.escpos.image.RasterBitImageWrapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EposTextToImageCretor {
    public void Get(EscPos escpos, String text, int fonsize, int imgwidth, int imgheight, int Xaxis, int Yaxis) {
        try {
            int FontSize = 30;
            int imageWidth = 576;
            int imageHeight = 15;
            int fromXaxis = 1;
            int fromYaxis = 15;
            if (imgheight != 0) {
                imageHeight = imgheight;
            }
            if (imgwidth != 0) {
                imageWidth = imgwidth;
            }
            if (fonsize != 0) {
                FontSize = fonsize;
            }
            if (Xaxis != 0) {
                fromXaxis = Xaxis;
            }
            if (Yaxis != 0) {
                fromYaxis = Yaxis;
            }
            BufferedImage image = new BufferedImage(imageWidth, imageHeight, 1);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, g.getDeviceConfiguration().getBounds().width, g.getDeviceConfiguration().getBounds().height);
            g.setColor(Color.BLACK);
            Font fontMonoSpaceBold = new Font("Monospaced", 1, FontSize);
            g.setFont(fontMonoSpaceBold);
            g.drawString(text, fromXaxis, fromYaxis);
            if (fontMonoSpaceBold.canDisplayUpTo(text) != -1) {
                throw new CharConversionException("the font doesn't work with these glyphs");
            }
            ImageHelper helper = new ImageHelper();
            BitonalThreshold algorithm = new BitonalThreshold();
            RasterBitImageWrapper imageWrapper = new RasterBitImageWrapper();
            helper.write(escpos, (CoffeeImage)new CoffeeImageImpl(image), (ImageWrapperInterface)imageWrapper, (Bitonal)algorithm);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private class ImageHelper {
        final int maxWidth;
        final int maxHeight;

        public ImageHelper() {
            this(576, 48);
        }

        public ImageHelper(int maxWidth, int maxHeight) {
            if (maxHeight < 24) {
                maxHeight = 24;
            }
            if (maxHeight % 24 != 0) {
                maxHeight -= maxHeight % 24;
            }
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
        }

        public List<CoffeeImage> sliceImage(CoffeeImage coffeeImage) {
            ArrayList<CoffeeImage> listImages = new ArrayList<CoffeeImage>();
            int x = 0;
            int y = 0;
            int x_offset = this.maxWidth;
            int y_offset = this.maxHeight;
            do {
                if (x > coffeeImage.getWidth() - 1) {
                    x = coffeeImage.getWidth() - 1;
                }
                if (x + x_offset > coffeeImage.getWidth()) {
                    x_offset = coffeeImage.getWidth() - x;
                }
                if (y >= coffeeImage.getHeight() - 1) {
                    y = coffeeImage.getHeight() - 1;
                }
                if (y + y_offset > coffeeImage.getHeight()) {
                    y_offset = coffeeImage.getHeight() - y;
                }
                CoffeeImage tmp = coffeeImage.getSubimage(0, y, x_offset, y_offset);
                listImages.add(tmp);
            } while ((y += y_offset) < coffeeImage.getHeight());
            return listImages;
        }

        public void write(EscPos escPos, CoffeeImage image, ImageWrapperInterface wrapper, Bitonal bitonalAlgorithm) throws IOException {
            List<CoffeeImage> images = this.sliceImage(image);
            for (CoffeeImage img : images) {
                escPos.write(wrapper, new EscPosImage(img, bitonalAlgorithm));
            }
        }
    }
}

