/*
 * Decompiled with CFR 0.152.
 */
package cloudconnector.uploaddbstracture;

import Utility.DbAction;
import Utility.StaticObjects;
import Utility.XmlParse;
import cloudconnector.CloudConnector;
import cloudconnector.ControlledScreenInterface;
import cloudconnector.ScreensController;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

public class DbstractureuploadController
implements Initializable,
ControlledScreenInterface {
    private ScreensController screencontroller;
    private final int split_rowsze = 500;
    int now_row_inserted = 1;
    private ArrayList<String> succ_up_tables = new ArrayList();
    @FXML
    private Label label_info;
    @FXML
    private Button bt_start;

    public void initialize(URL url, ResourceBundle rb) {
        Platform.runLater(() -> {
            try {
                if (StaticObjects.vimp_utility.BinaryLogWithCmdActualoutput("mysqldump").contains("is not recognized as an internal or external command")) {
                    DbAction c = new DbAction();
                    c.AlertServerConectionFailed("Pls Set Mysql in Environment Variable \n JAVA (location) = C:\\Program Files\\MySQL\\MySQL Server 5.5\\bin \n PHP (location)  = C:\\wamp\\bin\\mysql\\mysql5.5.16\\bin \n== CHEKING ==\n open cmd \n type mysqldump \n hit ENTER KEY \n== OUTPUT ==\nUsage: mysqldump [OPTIONS] database [tables]\nOR     mysqldump [OPTIONS] --databases [OPTIONS] DB1 [DB2 DB3...]\nOR     mysqldump [OPTIONS] --all-databases [OPTIONS]\nFor more options, use mysqldump --help");
                } else {
                    this.CheckclouddbStatus("0");
                }
            }
            catch (Exception e) {
                DbAction cc = new DbAction();
                cc.AlertServerConectionFailed("Data process failed..");
            }
        });
    }

    @Override
    public void setScreenParent_Interface(ScreensController screenPage) {
        this.screencontroller = screenPage;
    }

    private void CheckclouddbStatus(String tag) {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost("https://" + StaticObjects.Cloudip + "/UPLOAD_BRANCH_DATA_TO_CLOUD/dbcreation.php");
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("tag", tag));
            nameValuePairs.add(new BasicNameValuePair("dbname", XmlParse.SERVER_DATABASE_NAME));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            HttpResponse responce = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity enttity = responce.getEntity();
            InputStream sr = null;
            sr = enttity.getContent();
            BufferedReader bufferreader = new BufferedReader(new InputStreamReader(sr, "ISO-8859-1"), 8);
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = bufferreader.readLine()) != null) {
                sb.append(line + "\n");
            }
            sr.close();
            this.HttpResponce(sb);
        }
        catch (Exception ex) {
            DbAction c = new DbAction();
            c.AlertServerConectionFailed(ex.getMessage());
        }
    }

    private void HttpResponce(StringBuilder line) {
        try {
            JSONArray jarray = new JSONArray(line.toString());
            String data = "";
            String messege = "";
            int i = 0;
            if (i < jarray.length()) {
                JSONObject jsonobject = jarray.getJSONObject(i);
                data = jsonobject.getString("data");
                messege = jsonobject.getString("messege");
            }
            switch (data) {
                case "200": {
                    Alert alert1 = new Alert(Alert.AlertType.INFORMATION, messege, new ButtonType[]{ButtonType.OK});
                    DialogPane dialogPane12 = alert1.getDialogPane();
                    dialogPane12.getStylesheets().add((Object)this.getClass().getResource("/resource/css/controllfxdialog.css").toExternalForm());
                    dialogPane12.getStyleClass().add((Object)"myDialog");
                    alert1.initStyle(StageStyle.UNDECORATED);
                    alert1.showAndWait();
                    if (alert1.getResult() == ButtonType.OK) {
                        this.StartStructureUpload();
                    }
                    break;
                }
                case "300": {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, messege, new ButtonType[]{ButtonType.OK, ButtonType.NEXT, ButtonType.CANCEL});
                    alert.initStyle(StageStyle.UNDECORATED);
                    DialogPane dialogPane1 = alert.getDialogPane();
                    dialogPane1.getStylesheets().add((Object)this.getClass().getResource("/resource/css/controllfxdialog.css").toExternalForm());
                    dialogPane1.getStyleClass().add((Object)"myDialog");
                    ((Button)alert.getDialogPane().lookupButton(ButtonType.OK)).setText("Clear prv data and Upload");
                    ((Button)alert.getDialogPane().lookupButton(ButtonType.NEXT)).setText("Next page");
                    ((Button)alert.getDialogPane().lookupButton(ButtonType.CANCEL)).setText("Exit App");
                    alert.showAndWait();
                    if (alert.getResult() == ButtonType.OK) {
                        alert.close();
                        this.ClearCloudDB();
                        break;
                    }
                    if (alert.getResult() == ButtonType.NEXT) {
                        alert.close();
                        this.screencontroller.loadScreen(StaticObjects.screen_ownerappusercreation, StaticObjects.screen_ownerappusercreation_fxml);
                        this.screencontroller.setScreen(StaticObjects.screen_ownerappusercreation);
                        break;
                    }
                    if (alert.getResult() == ButtonType.CANCEL) {
                        alert.close();
                        System.exit(0);
                    }
                    break;
                }
                case "400": {
                    Alert alert3 = new Alert(Alert.AlertType.INFORMATION, messege, new ButtonType[]{ButtonType.OK});
                    alert3.initStyle(StageStyle.UNDECORATED);
                    DialogPane dialogPane = alert3.getDialogPane();
                    dialogPane.getStylesheets().add((Object)this.getClass().getResource("/resource/css/controllfxdialog.css").toExternalForm());
                    dialogPane.getStyleClass().add((Object)"myDialog");
                    alert3.showAndWait();
                    if (alert3.getResult() == ButtonType.OK) {
                        this.EXITapp();
                    }
                    break;
                }
                default: {
                    this.EXITapp();
                    break;
                }
            }
        }
        catch (Exception e3) {
            DbAction c = new DbAction();
            c.AlertServerConectionFailed(e3.getMessage());
        }
    }

    private void StartStructureUpload() {
        this.bt_start.setVisible(true);
        this.bt_start.setOnMouseClicked(event -> {
            this.bt_start.setVisible(false);
            this.bt_start.toBack();
            Platform.runLater(() -> {
                this.label_info.setText("Uploading  Database Structure Started...");
                this.succ_up_tables.clear();
                this.succ_up_tables.clear();
                this.now_row_inserted = 1;
                this.Startthred();
            });
        });
    }

    private void ClearCloudDB() {
        this.CheckclouddbStatus("1");
    }

    private void EXITapp() {
        Stage stage = StaticObjects.current_stage;
        StaticObjects.vimp_utility.StagetoCenterofScreen(stage);
        try {
            new CloudConnector().start(stage);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void Startthred() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    Thread.sleep(2000L);
                    int totaltables = 0;
                    String tempt = "";
                    int localcount = 0;
                    ArrayList<String> list_temps = new ArrayList<String>();
                    DbAction db = new DbAction();
                    ResultSet rs2 = db.SERVER_TableSelection_SELECTION(" SELECT COUNT(*) AS total FROM information_schema.TABLES where TABLE_SCHEMA='" + XmlParse.SERVER_DATABASE_NAME + "'");
                    while (rs2.next()) {
                        totaltables = rs2.getInt(1);
                    }
                    ResultSet rs = db.SERVER_TableSelection_SELECTION("SELECT TABLE_NAME,ENGINE FROM information_schema.TABLES where TABLE_SCHEMA='" + XmlParse.SERVER_DATABASE_NAME + "' ORDER BY TABLES.TABLE_NAME");
                    while (rs.next()) {
                        this.updateMessage("Uploading ...[ " + rs.getString(1) + " ](" + String.valueOf(DbstractureuploadController.this.now_row_inserted) + "/" + String.valueOf(totaltables) + ")");
                        ResultSet rs1 = db.SERVER_TableSelection_SELECTION("SHOW CREATE TABLE " + rs.getString(1));
                        while (rs1.next()) {
                            tempt = tempt + rs1.getString(2) + ";";
                            list_temps.add(rs1.getString(2));
                            if (++localcount < 20) continue;
                            DbstractureuploadController.this.HttpStrectureUploadtoSERVER(tempt, "0");
                            tempt = "";
                            DbstractureuploadController.this.now_row_inserted += localcount;
                            list_temps.clear();
                            localcount = 0;
                        }
                    }
                    DbstractureuploadController.this.HttpStrectureUploadtoSERVER(tempt, "0");
                }
                catch (SQLException ex) {
                    DbAction c = new DbAction();
                    c.AlertServerConectionFailed(ex.getMessage());
                }
                return null;
            }
        };
        task.setOnFailed(wse -> {
            this.now_row_inserted = 1;
            this.Startthred();
        });
        task.setOnSucceeded(wse -> Platform.runLater(() -> {
            this.label_info.textProperty().unbind();
            this.label_info.setText("Uploading  Tables data Started...");
            PauseTransition ps = StaticObjects.vimp_fxAnimation.PauseTransition(2.0);
            ps.play();
            ps.setOnFinished(event -> {
                this.succ_up_tables.clear();
                this.now_row_inserted = 1;
                this.UploadTablesData();
            });
        }));
        this.label_info.textProperty().bind((ObservableValue)task.messageProperty());
        new Thread((Runnable)task).start();
    }

    private void HttpStrectureUploadtoSERVER(String tableStructureQuery, String tag) {
        try {
            if (!"".equals(tableStructureQuery)) {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpPost httppost = new HttpPost("https://" + StaticObjects.Cloudip + "/UPLOAD_BRANCH_DATA_TO_CLOUD/dbdataupload.php");
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("tag", tag));
                nameValuePairs.add(new BasicNameValuePair("dbname", XmlParse.SERVER_DATABASE_NAME));
                nameValuePairs.add(new BasicNameValuePair("query", tableStructureQuery));
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                HttpResponse responce = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity httpEntity = responce.getEntity();
            }
        }
        catch (Exception ex) {
            DbAction c = new DbAction();
            c.AlertServerConectionFailed(ex.getMessage());
        }
    }

    private void UploadTablesData() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    int totaltables = 0;
                    DbAction db = new DbAction();
                    ResultSet rs2 = db.SERVER_TableSelection_SELECTION(" SELECT COUNT(*) AS total FROM information_schema.TABLES where TABLE_SCHEMA='" + XmlParse.SERVER_DATABASE_NAME + "'");
                    while (rs2.next()) {
                        totaltables = rs2.getInt(1);
                    }
                    ResultSet rs = db.SERVER_TableSelection_SELECTION("SELECT TABLE_NAME,ENGINE FROM information_schema.TABLES where TABLE_SCHEMA='" + XmlParse.SERVER_DATABASE_NAME + "' ORDER BY TABLES.TABLE_NAME");
                    while (rs.next()) {
                        if (DbstractureuploadController.this.succ_up_tables.contains(rs.getString(1))) continue;
                        this.updateMessage("Uploading Data ...[ " + rs.getString(1) + " ](" + String.valueOf(DbstractureuploadController.this.now_row_inserted) + "/" + String.valueOf(totaltables) + ")");
                        int totalrowcount = 0;
                        ResultSet rs1 = db.SERVER_TableSelection_SELECTION("SELECT COUNT(*) AS total FROM " + rs.getString(1));
                        while (rs1.next()) {
                            totalrowcount = rs1.getInt(1);
                        }
                        if (totalrowcount <= 500) {
                            if (totalrowcount != 0) {
                                String q1 = "mysqldump -u " + XmlParse.SERVER_DB_USERNAME + " -p" + XmlParse.SERVER_DB_PASSWORD + " --port=" + XmlParse.SERVER_DATABASE_PORTNO + " " + XmlParse.SERVER_DATABASE_NAME + " " + rs.getString(1) + " -q -t --skip-comments --compact ";
                                DbstractureuploadController.this.HttpStrectureUploadtoSERVER(StaticObjects.vimp_utility.BinaryLogWithCmdActualoutput(q1), "1");
                            }
                            if (DbstractureuploadController.this.succ_up_tables.contains(rs.getString(1))) continue;
                            DbstractureuploadController.this.succ_up_tables.add(rs.getString(1));
                            ++DbstractureuploadController.this.now_row_inserted;
                            continue;
                        }
                        int k = totalrowcount / 500;
                        int startrow = 1;
                        int skiprow = 0;
                        for (int j = 0; j <= k + 3; ++j) {
                            String q1 = "mysqldump -u " + XmlParse.SERVER_DB_USERNAME + " -p" + XmlParse.SERVER_DB_PASSWORD + " --port=" + XmlParse.SERVER_DATABASE_PORTNO + " " + XmlParse.SERVER_DATABASE_NAME + " " + rs.getString(1) + " -q -t --skip-comments --compact  --where=\" " + startrow + " limit " + skiprow + ", " + 500 + "\" ";
                            skiprow = startrow = 500 * (j + 1);
                            DbstractureuploadController.this.HttpStrectureUploadtoSERVER(StaticObjects.vimp_utility.BinaryLogWithCmdActualoutput(q1), "1");
                            if (DbstractureuploadController.this.succ_up_tables.contains(rs.getString(1))) continue;
                            DbstractureuploadController.this.succ_up_tables.add(rs.getString(1));
                            ++DbstractureuploadController.this.now_row_inserted;
                        }
                    }
                }
                catch (SQLException ex) {
                    DbAction c = new DbAction();
                    c.AlertServerConectionFailed(ex.getMessage());
                }
                return null;
            }
        };
        task.setOnFailed(wse -> this.UploadTablesData());
        task.setOnSucceeded(wse -> Platform.runLater(() -> {
            this.label_info.textProperty().unbind();
            this.label_info.setText("Upload  Completed...");
            PauseTransition ps = StaticObjects.vimp_fxAnimation.PauseTransition(4.0);
            ps.play();
            ps.setOnFinished(event -> {
                this.screencontroller.loadScreen(StaticObjects.screen_ownerappusercreation, StaticObjects.screen_ownerappusercreation_fxml);
                this.screencontroller.setScreen(StaticObjects.screen_ownerappusercreation);
            });
        }));
        this.label_info.textProperty().bind((ObservableValue)task.messageProperty());
        new Thread((Runnable)task).start();
    }
}

