/*
 * Decompiled with CFR 0.152.
 */
package cloudconnector.ownerapppasswordset;

import Utility.DbAction;
import Utility.StaticObjects;
import Utility.XmlParse;
import cloudconnector.ControlledScreenInterface;
import cloudconnector.ScreensController;
import com.jfoenix.controls.JFXTextField;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.stage.StageStyle;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

public class OwnerappuserpasssetController
implements Initializable,
ControlledScreenInterface {
    private ScreensController screencontroller;
    @FXML
    private JFXTextField txt_shopname;
    @FXML
    private JFXTextField txt_password;
    @FXML
    private Button bt_genaratetoken;
    @FXML
    private Button bt_next;

    public void initialize(URL url, ResourceBundle rb) {
        this.NumberValidation((TextField)this.txt_password);
        this.bt_next.setOnMouseClicked(event -> {
            this.screencontroller.loadScreen(StaticObjects.screen_tableexclude, StaticObjects.screen_tableexclude_fxml);
            this.screencontroller.setScreen(StaticObjects.screen_tableexclude);
        });
        this.bt_genaratetoken.setOnMouseClicked(event -> {
            if (this.txt_shopname.getText().trim().length() == 0) {
                StaticObjects.vimp_utility.SnakeBar((Pane)this.screencontroller, "Shopname is empty... ", 3L);
            } else if (this.txt_password.getText().trim().length() != 4) {
                StaticObjects.vimp_utility.SnakeBar((Pane)this.screencontroller, "Password must have 4 digit ", 3L);
            } else {
                this.GenerateApptoken(this.txt_password.getText().trim(), this.txt_shopname.getText().trim());
            }
        });
    }

    @Override
    public void setScreenParent_Interface(ScreensController screenPage) {
        this.screencontroller = screenPage;
    }

    private void NumberValidation(final TextField tf) {
        tf.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches(StaticObjects.vimp_utility.TextBox_Number())) {
                tf.setText(newValue.replaceAll(StaticObjects.vimp_utility.TextBox_Number_Not(), ""));
            }
        });
        tf.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean t, Boolean t1) {
                Platform.runLater(() -> {
                    if (tf.isFocused() && !tf.getText().isEmpty()) {
                        tf.selectAll();
                    }
                });
            }
        });
    }

    private void GenerateApptoken(String apppass, String shopname) {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost("https://" + StaticObjects.Cloudip + "/UPLOAD_BRANCH_DATA_TO_CLOUD/ownerappusercreation.php");
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("userpass", apppass));
            nameValuePairs.add(new BasicNameValuePair("shopname", shopname));
            nameValuePairs.add(new BasicNameValuePair("dbname", XmlParse.SERVER_DATABASE_NAME));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            HttpResponse responce = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity enttity = responce.getEntity();
            InputStream sr = null;
            sr = enttity.getContent();
            BufferedReader bufferreader = new BufferedReader(new InputStreamReader(sr, "ISO-8859-1"), 8);
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = bufferreader.readLine()) != null) {
                sb.append(line + "\n");
            }
            sr.close();
            this.HttpResponce(sb);
        }
        catch (Exception ex) {
            DbAction c = new DbAction();
            c.AlertServerConectionFailed(ex.getMessage());
        }
    }

    private void HttpResponce(StringBuilder line) {
        try {
            JSONArray jarray = new JSONArray(line.toString());
            String data = "";
            String messege = "";
            int i = 0;
            if (i < jarray.length()) {
                JSONObject jsonobject = jarray.getJSONObject(i);
                data = jsonobject.getString("data");
                messege = jsonobject.getString("messege");
            }
            switch (data) {
                case "200": {
                    this.bt_next.setVisible(true);
                    Alert alert1 = new Alert(Alert.AlertType.INFORMATION, "App Token No:" + messege + "\n Press Next Button to add Exclude Tables", new ButtonType[]{ButtonType.NEXT});
                    DialogPane dialogPane12 = alert1.getDialogPane();
                    dialogPane12.getStylesheets().add((Object)this.getClass().getResource("/resource/css/controllfxdialog.css").toExternalForm());
                    dialogPane12.getStyleClass().add((Object)"myDialog");
                    alert1.initStyle(StageStyle.UNDECORATED);
                    alert1.showAndWait();
                    if (alert1.getResult() == ButtonType.NEXT) {
                        alert1.close();
                        this.screencontroller.loadScreen(StaticObjects.screen_tableexclude, StaticObjects.screen_tableexclude_fxml);
                        this.screencontroller.setScreen(StaticObjects.screen_tableexclude);
                    }
                    break;
                }
                case "300": {
                    this.bt_next.setVisible(true);
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, messege, new ButtonType[]{ButtonType.OK});
                    alert.initStyle(StageStyle.UNDECORATED);
                    DialogPane dialogPane1 = alert.getDialogPane();
                    dialogPane1.getStylesheets().add((Object)this.getClass().getResource("/resource/css/controllfxdialog.css").toExternalForm());
                    dialogPane1.getStyleClass().add((Object)"myDialog");
                    alert.showAndWait();
                    if (alert.getResult() == ButtonType.OK) {
                        alert.close();
                    }
                    break;
                }
                case "400": {
                    this.bt_next.setVisible(true);
                    Alert alert3 = new Alert(Alert.AlertType.INFORMATION, messege, new ButtonType[]{ButtonType.OK});
                    alert3.initStyle(StageStyle.UNDECORATED);
                    DialogPane dialogPane = alert3.getDialogPane();
                    dialogPane.getStylesheets().add((Object)this.getClass().getResource("/resource/css/controllfxdialog.css").toExternalForm());
                    dialogPane.getStyleClass().add((Object)"myDialog");
                    alert3.showAndWait();
                    if (alert3.getResult() == ButtonType.OK) {
                        alert3.close();
                    }
                    break;
                }
                default: {
                    this.bt_next.setVisible(true);
                    break;
                }
            }
        }
        catch (Exception e3) {
            DbAction c = new DbAction();
            c.AlertServerConectionFailed(e3.getMessage());
        }
    }
}

