/*
 * Decompiled with CFR 0.152.
 */
package cloudconnector;

import cloudconnector.ControlledScreenInterface;
import java.io.IOException;
import java.util.HashMap;
import javafx.beans.property.DoubleProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.StackPane;

public class ScreensController
extends StackPane {
    private HashMap<String, Node> screens = new HashMap();

    public void addScreen(String name, Node screen) {
        this.screens.put(name, screen);
    }

    public Node getScreen(String name) {
        return this.screens.get(name);
    }

    public boolean loadScreen(String name, String resource) {
        try {
            FXMLLoader myLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(resource));
            Parent loadScreen = (Parent)myLoader.load();
            ControlledScreenInterface myScreenControler = (ControlledScreenInterface)myLoader.getController();
            myScreenControler.setScreenParent_Interface(this);
            this.addScreen(name, (Node)loadScreen);
            return true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public boolean setScreen(String name) {
        if (this.screens.get(name) != null) {
            DoubleProperty opacity = this.opacityProperty();
            if (!this.getChildren().isEmpty()) {
                this.getChildren().remove(0);
                this.getChildren().add(0, (Object)this.screens.get(name));
            } else {
                this.getChildren().add((Object)this.screens.get(name));
            }
            return true;
        }
        System.out.println("screen hasn't been loaded!!! \n");
        return false;
    }

    public boolean unloadScreen(String name) {
        if (this.screens.remove(name) == null) {
            System.out.println("Screen didn't exist");
            return false;
        }
        return true;
    }
}

